/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi;

import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.APIRegistries;
import xyz.pixelatedw.mineminenomi.wypi.ModdedSpawnEggItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class WyRegistry {
    private static HashMap<String, String> langMap = new HashMap();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)APIConfig.projectId);
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)APIConfig.projectId);
    public static final DeferredRegister<ContainerType<?>> CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)APIConfig.projectId);
    public static final DeferredRegister<Ability> ABILITIES = DeferredRegister.create(APIRegistries.ABILITIES, (String)APIConfig.projectId);
    public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)APIConfig.projectId);
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)APIConfig.projectId);
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)APIConfig.projectId);
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)APIConfig.projectId);
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)APIConfig.projectId);
    public static final DeferredRegister<Quest> QUESTS = DeferredRegister.create(APIRegistries.QUESTS, (String)APIConfig.projectId);
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)APIConfig.projectId);
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)APIConfig.projectId);
    public static final DeferredRegister<ModDimension> DIMENSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOD_DIMENSIONS, (String)APIConfig.projectId);

    public static HashMap<String, String> getLangMap() {
        return langMap;
    }

    public static String registerName(String key, String localizedName) {
        langMap.put(key, localizedName);
        return key;
    }

    public static void registerParticleType(ParticleType<?> type, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        PARTICLE_TYPES.register(resourceName, () -> type);
    }

    public static Feature<?> registerFeature(Feature<?> feature, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        FEATURES.register(resourceName, () -> feature);
        return feature;
    }

    public static Effect registerEffect(Effect effect, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        return WyRegistry.registerEffect(effect, localizedName, resourceName);
    }

    public static Effect registerEffect(Effect effect, String localizedName, String resourceKey) {
        String resourceName = WyHelper.getResourceName(resourceKey);
        langMap.put("effect." + APIConfig.projectId + "." + resourceName, localizedName);
        EFFECTS.register(resourceName, () -> effect);
        return effect;
    }

    public static Enchantment registerEnchantment(Enchantment enchantment, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        langMap.put("enchantment." + APIConfig.projectId + "." + resourceName, localizedName);
        ENCHANTMENTS.register(resourceName, () -> enchantment);
        return enchantment;
    }

    public static Quest registerQuest(Quest quest) {
        String resourceName = WyHelper.getResourceName(quest.getId());
        langMap.put("quest." + APIConfig.projectId + "." + resourceName, quest.getTitle());
        for (Objective obj : quest.getObjectives()) {
            langMap.put("quest.objective." + APIConfig.projectId + "." + obj.getId(), obj.getTitle());
        }
        QUESTS.register(resourceName, () -> quest);
        return quest;
    }

    public static Ability registerAbility(Ability ability) {
        String resourceName = WyHelper.getResourceName(ability.getName());
        langMap.put(ability.getI18nKey(), ability.getName());
        ResourceLocation key = new ResourceLocation(APIConfig.projectId, resourceName);
        RegistryObject ret = RegistryObject.of((ResourceLocation)key, APIRegistries.ABILITIES);
        if (!ABILITIES.getEntries().contains(ret)) {
            ABILITIES.register(resourceName, () -> ability);
        }
        return ability;
    }

    public static Item registerItem(Item item, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        langMap.put("item." + APIConfig.projectId + "." + resourceName, localizedName);
        ITEMS.register(resourceName, () -> item);
        return item;
    }

    public static SoundEvent registerSound(String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        SoundEvent sound = new SoundEvent(new ResourceLocation(APIConfig.projectId, resourceName));
        SOUNDS.register(resourceName, () -> sound);
        return sound;
    }

    public static Item registerSpawnEggItem(EntityType type, String localizedEntityName, int backgroundColor, int foregroundColor) {
        String entityResName = WyHelper.getResourceName(localizedEntityName);
        ModdedSpawnEggItem egg = new ModdedSpawnEggItem(() -> type, backgroundColor, foregroundColor, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        String resourceName = entityResName + "_spawn_egg";
        String localizedName = "Spawn " + localizedEntityName;
        langMap.put("item." + APIConfig.projectId + "." + resourceName, localizedName);
        ITEMS.register(resourceName, () -> egg);
        return egg;
    }

    public static Block registerBlock(Block block, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        langMap.put("block." + APIConfig.projectId + "." + resourceName, localizedName);
        BLOCKS.register(resourceName, () -> block);
        return block;
    }

    public static <T extends TileEntity> TileEntityType.Builder<T> createTileEntity(Supplier<T> factory, Block ... blocks) {
        TileEntityType.Builder type = TileEntityType.Builder.func_223042_a(factory, (Block[])blocks);
        return type;
    }

    public static <T extends TileEntity> void registerTileEntity(TileEntityType<T> type, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        TILE_ENTITIES.register(resourceName, () -> type);
    }

    public static <T extends Entity> EntityType.Builder<T> createEntityType(Function<World, T> func) {
        return WyRegistry.createEntityType(func, EntityClassification.MISC);
    }

    public static <T extends Entity> EntityType.Builder<T> createEntityType(Function<World, T> func, EntityClassification classification) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a((entityType, world) -> (Entity)func.apply(world), (EntityClassification)classification);
        builder.setTrackingRange(128).setShouldReceiveVelocityUpdates(true).setUpdateInterval(1).setCustomClientFactory((entity, world) -> (Entity)func.apply((World)world)).func_220321_a(0.6f, 1.8f);
        return builder;
    }

    public static <T extends Entity> EntityType.Builder<T> createFastEntityType(EntityType.IFactory<T> factory) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MISC);
        builder.setTrackingRange(128).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_220321_a(0.6f, 1.8f);
        return builder;
    }

    public static <T extends Entity> void registerEntityType(EntityType<T> type, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        langMap.put("entity." + APIConfig.projectId + "." + resourceName, localizedName);
        ENTITY_TYPES.register(resourceName, () -> type);
    }

    public static void registerContainerType(ContainerType<?> type, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        langMap.put("container." + APIConfig.projectId + "." + resourceName, localizedName);
        CONTAINER_TYPES.register(resourceName, () -> type);
    }

    public static void registerDimension(ModDimension dimension, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        dimension.setRegistryName(ModResources.DIMENSION_TYPE_CHALLENGES);
        langMap.put("dimension." + APIConfig.projectId + "." + resourceName, localizedName);
        DIMENSIONS.register(resourceName, () -> dimension);
    }
}

