/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.abilities;

import java.io.Serializable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SAnimeScreamPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PunchAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public abstract class ContinuousAbility
extends Ability {
    private int threshold = 0;
    protected int continueTime = 0;
    protected IOnStartContinuity onStartContinuityEvent = player -> true;
    protected IOnEndContinuity onEndContinuityEvent = player -> true;
    protected IDuringContinuity duringContinuityEvent = (player, continuousTime) -> {};

    public ContinuousAbility(String name, APIConfig.AbilityCategory category) {
        super(name, category);
    }

    @Override
    public void use(PlayerEntity player) {
        AbilityUseEvent event;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isOnCooldown() && this.getCooldown() <= 10.0) {
            this.stopCooldown(player);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new AbilityUseEvent(player, this)))) {
            return;
        }
        if (!this.isContinuous()) {
            if (!this.isOnStandby()) {
                return;
            }
            if (this.onStartContinuityEvent.onStartContinuity(player)) {
                this.checkAbilityPool(player, Ability.State.CONTINUOUS);
                if (((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue() && !(this instanceof PunchAbility)) {
                    WyNetwork.sendToAllTrackingAndSelf(new SAnimeScreamPacket(player.func_145782_y(), this.getDisplayName()), (LivingEntity)player);
                }
                this.startContinuity(player);
                WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
            }
        } else if (!this.isStateForced() && this.onEndContinuityEvent.onEndContinuity(player)) {
            this.checkAbilityPool(player, Ability.State.COOLDOWN);
            this.stopContinuity(player);
        }
    }

    public void setThreshold(double threshold) {
        this.threshold = (int)(threshold * 20.0);
    }

    public void setThresholdInTicks(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setContinueTime(int time) {
        this.continueTime = time * 20;
    }

    public int getContinueTime() {
        return this.continueTime;
    }

    public void tick(PlayerEntity player) {
        if (!this.canUse(player)) {
            this.stopContinuity(player);
            return;
        }
        player.field_70170_p.func_217381_Z().func_76320_a(WyHelper.getResourceName(this.getName()));
        if (this.isContinuous()) {
            ++this.continueTime;
            if (!player.field_70170_p.field_72995_K && !this.isStateForced()) {
                this.duringContinuityEvent.duringContinuity(player, this.continueTime);
            }
            if (this.threshold > 0 && this.continueTime >= this.threshold) {
                this.stopContinuity(player);
            }
        }
        player.field_70170_p.func_217381_Z().func_76319_b();
    }

    public void startContinuity(PlayerEntity player) {
        this.setState(Ability.State.CONTINUOUS);
    }

    public void stopContinuity(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.onEndContinuityEvent.onEndContinuity(player)) {
            this.continueTime = 0;
            this.startCooldown(player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
        }
    }

    public static interface IOnEndContinuity
    extends Serializable {
        public boolean onEndContinuity(PlayerEntity var1);
    }

    public static interface IOnStartContinuity
    extends Serializable {
        public boolean onStartContinuity(PlayerEntity var1);
    }

    public static interface IDuringContinuity
    extends Serializable {
        public void duringContinuity(PlayerEntity var1, int var2);
    }
}

