/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiFullBodyHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.ProjectileBlockEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.ProjectileHitEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.ProjectileShootEvent;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;

public class AbilityProjectileEntity
extends ThrowableEntity {
    private int life = 64;
    private int maxLife = 64;
    private int knockbackStrength = 0;
    private double collisionSize = 1.0;
    private float damage = 0.1f;
    private float gravity = 1.0E-4f;
    private boolean canPassThroughBlocks = false;
    private boolean canPassThroughEntities = false;
    private boolean canGetStuckInGround = false;
    protected boolean stuckInGround = false;
    private boolean changeHurtTime = false;
    private boolean armorPiercing = false;
    private boolean canHurtThrower = false;
    private int hurtTime = 10;
    boolean entityDamaged = false;
    boolean applyOnlyOnce = true;
    private List<Integer> targets = new ArrayList<Integer>();
    private int targetResetTime = 20;
    private static final DataParameter<Integer> OWNER = EntityDataManager.func_187226_a(AbilityProjectileEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_PHYSICAL = EntityDataManager.func_187226_a(AbilityProjectileEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_AFFECTED_BY_HARDENING = EntityDataManager.func_187226_a(AbilityProjectileEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_AFFECTED_BY_IMBUING = EntityDataManager.func_187226_a(AbilityProjectileEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public IOnEntityImpact onEntityImpactEvent = hitEntity -> {
        if (!this.targets.contains(hitEntity.func_145782_y())) {
            this.onBlockImpactEvent.onImpact(hitEntity.func_180425_c());
        }
    };
    public IOnBlockImpact onBlockImpactEvent;
    public IOnTick onTickEvent;
    public IWithEffects withEffects;
    public DamageSource source;
    public DamageSource bypassingSource;
    private static final Block[] NON_SOLID_BLOCKS = new Block[]{Blocks.field_150349_c, Blocks.field_196804_gh, Blocks.field_203198_aQ, Blocks.field_203199_aR, Blocks.field_150395_bd, Blocks.field_150488_af, Blocks.field_196555_aI, Blocks.field_196802_gf};

    public AbilityProjectileEntity(EntityType type, World world) {
        super(type, world);
        this.onBlockImpactEvent = hit -> {};
        this.onTickEvent = () -> {};
        this.withEffects = () -> new EffectInstance[0];
    }

    public AbilityProjectileEntity(EntityType type, World world, double x, double y, double z) {
        super(type, x, y, z, world);
        this.onBlockImpactEvent = hit -> {};
        this.onTickEvent = () -> {};
        this.withEffects = () -> new EffectInstance[0];
    }

    public AbilityProjectileEntity(EntityType type, World world, LivingEntity thrower) {
        super(type, thrower, world);
        this.onBlockImpactEvent = hit -> {};
        this.onTickEvent = () -> {};
        this.withEffects = () -> new EffectInstance[0];
        this.maxLife = this.life;
        this.damage = 0.1f;
        this.setThrower(thrower);
        this.source = new IndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)thrower).func_76349_b();
        this.bypassingSource = new IndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)thrower).func_76349_b().func_76348_h();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.life <= 0) {
                this.life = this.maxLife;
                this.func_70106_y();
                return;
            }
            --this.life;
            if (ExtendedWorldData.get(this.field_70170_p).isInsideRestrictedArea((int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_())) {
                this.func_70106_y();
                return;
            }
        }
        Vec3d vec31 = new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Vec3d vec3 = new Vec3d(this.func_226277_ct_() + this.func_213322_ci().field_72450_a, this.func_226278_cu_() + this.func_213322_ci().field_72448_b, this.func_226281_cx_() + this.func_213322_ci().field_72449_c);
        BlockRayTraceResult hit = this.field_70170_p.func_217299_a(new RayTraceContext(vec3, vec31, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, (Entity)this));
        double sizeX = this.collisionSize;
        double sizeY = this.collisionSize;
        double sizeZ = this.collisionSize;
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_72314_b(sizeX, sizeY, sizeZ);
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, aabb);
        Entity entity = null;
        for (Entity target : list) {
            if (!target.func_70067_L() || target == this.func_85052_h() && this.field_70173_aa < 5) continue;
            entity = target;
        }
        if (entity == this.func_85052_h()) {
            return;
        }
        if (entity != null) {
            hit = new EntityRayTraceResult(entity);
        }
        if (hit.func_216346_c() == RayTraceResult.Type.ENTITY) {
            this.func_70184_a((RayTraceResult)hit);
        }
        if (this.field_70173_aa % this.getTargetResetTime() == 0) {
            this.clearTargets();
        }
        this.onTickEvent.onTick();
    }

    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        ProjectileShootEvent event = new ProjectileShootEvent(this, velocity, inaccuracy);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        this.clearTargets();
        super.func_184538_a(entityThrower, rotationPitchIn, rotationYawIn, pitchOffset, velocity, inaccuracy);
    }

    public boolean func_210500_b(Tag<Fluid> fluidTag) {
        if (this.field_70171_ac) {
            this.func_71061_d_();
        }
        return false;
    }

    protected void func_70184_a(RayTraceResult hit) {
        if (!this.field_70170_p.field_72995_K) {
            if (hit.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult entityHit = (EntityRayTraceResult)hit;
                if (entityHit.func_216348_a() instanceof LivingEntity && this.func_85052_h() != null) {
                    LivingEntity hitEntity = (LivingEntity)entityHit.func_216348_a();
                    IEntityStats statProps = EntityStatsCapability.get(this.func_85052_h());
                    if (hitEntity == this.func_85052_h() && !this.canHurtThrower) {
                        return;
                    }
                    ProjectileHitEvent event = new ProjectileHitEvent(this, hit);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    if (!this.entityDamaged && !this.targets.contains(hitEntity.getEntity().func_145782_y()) && hitEntity.getEntity().func_70089_S()) {
                        if (this.source == null) {
                            this.source = new IndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)this.func_85052_h()).func_76349_b();
                        }
                        if (this.bypassingSource == null) {
                            this.bypassingSource = new IndirectEntityDamageSource("ability_projectile", (Entity)this, (Entity)this.func_85052_h()).func_76349_b().func_76348_h();
                        }
                        if (!this.canBlockDamageSource(this.source, hitEntity)) {
                            if (this.isAffectedByHardening() && this.func_85052_h() != null && this.applyOnlyOnce) {
                                boolean hasFullBodyBusoHakiActive;
                                IHakiData hakiProps = HakiDataCapability.get(this.func_85052_h());
                                IAbilityData attackerAbilityProps = AbilityDataCapability.get(this.func_85052_h());
                                BusoshokuHakiHardeningAbility busoHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
                                boolean hasBusoHakiActive = busoHaki != null && busoHaki.isContinuous();
                                BusoshokuHakiFullBodyHardeningAbility fullBodyBusoHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
                                boolean bl = hasFullBodyBusoHakiActive = fullBodyBusoHaki != null && fullBodyBusoHaki.isContinuous();
                                if (hasBusoHakiActive || hasFullBodyBusoHakiActive) {
                                    this.damage = (float)((double)this.damage * (1.0 + Math.min((double)(hakiProps.getBusoshokuHardeningHakiExp() / (float)(this.isPhysical() ? 200 : 400)), 0.5)));
                                }
                                WyDebug.debug("Hardening Haki Projectile Damage: " + this.damage);
                                this.applyOnlyOnce = false;
                            }
                            this.damage = (float)((double)this.damage * statProps.getDamageMultiplier());
                            if (this.armorPiercing) {
                                float reduction = this.getArmorDamage();
                                this.entityDamaged = hitEntity.func_70097_a(this.source, this.damage - reduction);
                                hitEntity.field_70172_ad = 0;
                                hitEntity.field_70737_aN = 0;
                                hitEntity.func_70097_a(this.bypassingSource, reduction);
                            } else {
                                this.entityDamaged = hitEntity.func_70097_a(this.source, this.damage);
                            }
                        } else if (hitEntity.func_184607_cu().func_77973_b() instanceof ShieldItem) {
                            hitEntity.func_184607_cu().func_222118_a((int)(this.getDamage() + 17.0f), hitEntity, p_220282_1_ -> p_220282_1_.func_213334_d(hitEntity.func_184600_cs()));
                        }
                    }
                    if (this.entityDamaged) {
                        Vec3d vec3d;
                        this.triggerEffects(hitEntity);
                        this.onEntityImpactEvent.onImpact(hitEntity);
                        if (this.knockbackStrength > 0 && (vec3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                            hitEntity.func_70024_g(vec3d.field_72450_a, 0.1, vec3d.field_72449_c);
                        }
                        if (!this.canPassThroughEntities) {
                            this.func_70106_y();
                        } else {
                            this.targets.add(entityHit.func_216348_a().func_145782_y());
                            this.entityDamaged = false;
                        }
                    }
                    if (this.changeHurtTime) {
                        hitEntity.field_70172_ad = this.hurtTime;
                    }
                } else if (entityHit.func_216348_a() instanceof AbilityProjectileEntity) {
                    AbilityProjectileEntity entity = (AbilityProjectileEntity)entityHit.func_216348_a();
                    this.onProjectileCollision(this, entity);
                }
            } else if (hit.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockHit = (BlockRayTraceResult)hit;
                ProjectileHitEvent event = new ProjectileHitEvent(this, hit);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                if (!this.passedThroughNonSolidBlock(blockHit.func_216350_a()) && !this.canPassThroughBlocks) {
                    this.onBlockImpactEvent.onImpact(blockHit.func_216350_a());
                    if (!this.canGetStuckInGround) {
                        this.func_70106_y();
                    }
                }
            }
        }
    }

    public void onProjectileCollision(AbilityProjectileEntity owner, AbilityProjectileEntity target) {
        boolean isDamageLarger;
        boolean isPhysical = owner.isPhysical();
        boolean isTargetPhysical = target.isPhysical();
        boolean bl = isDamageLarger = owner.getDamage() > target.getDamage();
        if (isPhysical) {
            if (isTargetPhysical) {
                if (isDamageLarger) {
                    target.func_70106_y();
                } else {
                    owner.func_70106_y();
                }
            } else {
                owner.func_70106_y();
            }
        } else if (isTargetPhysical) {
            target.func_70106_y();
        } else if (isDamageLarger) {
            target.func_70106_y();
        } else {
            owner.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float getArmorDamage() {
        float reduction = (float)((double)this.damage * (0.1 + (double)(this.damage / 150.0f)));
        if (reduction > this.damage) {
            reduction = this.damage;
        }
        return reduction;
    }

    public void triggerEffects(LivingEntity hitEntity) {
        if (this.withEffects.getEffects().length > 0) {
            for (EffectInstance instance : this.withEffects.getEffects()) {
                hitEntity.func_195064_c(instance);
                if (!(this.func_85052_h() instanceof ServerPlayerEntity)) continue;
                ((ServerPlayerEntity)this.func_85052_h()).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(hitEntity.func_145782_y(), instance));
            }
        }
    }

    public boolean canBlockDamageSource(DamageSource damageSource, LivingEntity target) {
        Vec3d vec3d2;
        if (damageSource == null) {
            return false;
        }
        ProjectileBlockEvent event = new ProjectileBlockEvent(damageSource.func_76364_f());
        boolean flag = event.canBlock();
        if (!damageSource.func_76363_c() && target.func_184585_cz() && flag && (vec3d2 = damageSource.func_188404_v()) != null) {
            Vec3d vec3d = this.func_70676_i(1.0f);
            Vec3d vec3d1 = vec3d2.func_72444_a(new Vec3d(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_())).func_72432_b();
            vec3d1 = new Vec3d(vec3d1.field_72450_a, 0.0, vec3d1.field_72449_c);
            return vec3d1.func_72430_b(vec3d) < 0.0;
        }
        return false;
    }

    public void setDamageSource(DamageSource s) {
        this.source = s;
    }

    private boolean passedThroughNonSolidBlock(BlockPos pos) {
        return Arrays.stream(NON_SOLID_BLOCKS).anyMatch(block -> this.field_70170_p.func_180495_p(pos).func_177230_c() == block);
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("life", this.life);
        compound.func_74768_a("maxLife", this.maxLife);
        compound.func_74768_a("hurtTime", this.hurtTime);
        compound.func_74768_a("knockbackStrength", this.knockbackStrength);
        compound.func_74776_a("damage", this.damage);
        compound.func_74776_a("gravity", this.gravity);
        compound.func_74780_a("collisionSize", this.collisionSize);
        compound.func_74757_a("isPhysical", ((Boolean)this.field_70180_af.func_187225_a(IS_PHYSICAL)).booleanValue());
        compound.func_74757_a("usesBusoHaki", ((Boolean)this.field_70180_af.func_187225_a(IS_AFFECTED_BY_HARDENING)).booleanValue());
        compound.func_74757_a("affectedByImbuing", ((Boolean)this.field_70180_af.func_187225_a(IS_AFFECTED_BY_IMBUING)).booleanValue());
        compound.func_74757_a("canPassThroughBlocks", this.canPassThroughBlocks);
        compound.func_74757_a("canPassThroughEntities", this.canPassThroughEntities);
        compound.func_74757_a("canGetStuckInGround", this.canGetStuckInGround);
        compound.func_74757_a("changeHurtTime", this.changeHurtTime);
        compound.func_74757_a("armorPiercing", this.armorPiercing);
        compound.func_74757_a("canHurtThrower", this.canHurtThrower);
        compound.func_74768_a("ownerUUID", ((Integer)this.field_70180_af.func_187225_a(OWNER)).intValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.life = compound.func_74762_e("life");
        this.maxLife = compound.func_74762_e("maxLife");
        this.hurtTime = compound.func_74762_e("hurtTime");
        this.knockbackStrength = compound.func_74762_e("knockbackStrength");
        this.damage = compound.func_74760_g("damage");
        this.gravity = compound.func_74760_g("gravity");
        this.collisionSize = compound.func_74769_h("collisionSize");
        this.field_70180_af.func_187227_b(IS_PHYSICAL, (Object)compound.func_74767_n("isPhysical"));
        this.field_70180_af.func_187227_b(IS_AFFECTED_BY_HARDENING, (Object)compound.func_74767_n("usesBusoHaki"));
        this.field_70180_af.func_187227_b(IS_AFFECTED_BY_IMBUING, (Object)compound.func_74767_n("affectedByImbuing"));
        this.canPassThroughBlocks = compound.func_74767_n("canPassThroughBlocks");
        this.canPassThroughEntities = compound.func_74767_n("canPassThroughEntities");
        this.canGetStuckInGround = compound.func_74767_n("canGetStuckInGround");
        this.changeHurtTime = compound.func_74767_n("changeHurtTime");
        this.armorPiercing = compound.func_74767_n("armorPiercing");
        this.canHurtThrower = compound.func_74767_n("canHurtThrower");
        this.field_70180_af.func_187227_b(OWNER, (Object)compound.func_74762_e("ownerUUID"));
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void clearTargets() {
        this.targets.clear();
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, (Object)-1);
        this.field_70180_af.func_187214_a(IS_PHYSICAL, (Object)false);
        this.field_70180_af.func_187214_a(IS_AFFECTED_BY_HARDENING, (Object)false);
        this.field_70180_af.func_187214_a(IS_AFFECTED_BY_IMBUING, (Object)false);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setThrower(LivingEntity entity) {
        this.field_70180_af.func_187227_b(OWNER, (Object)entity.func_145782_y());
        this.field_70192_c = entity;
    }

    @Nullable
    public LivingEntity func_85052_h() {
        return this.func_184212_Q().func_187225_a(OWNER) != null && this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(OWNER)).intValue()) instanceof LivingEntity ? (LivingEntity)this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(OWNER)).intValue()) : super.func_85052_h();
    }

    public void setKnockbackStrength(int knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    public double getCollisionSize() {
        return this.collisionSize;
    }

    public void setCollisionSize(double val) {
        this.collisionSize = val;
    }

    public int getLife() {
        return this.life;
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public void setMaxLife(int life) {
        this.life = this.maxLife = life;
    }

    public void setLife(int life) {
        this.life = life;
    }

    public void setPhysical(boolean affectedByHardening) {
        this.field_70180_af.func_187227_b(IS_PHYSICAL, (Object)true);
        this.field_70180_af.func_187227_b(IS_AFFECTED_BY_HARDENING, (Object)affectedByHardening);
    }

    public void setAffectedByImbuing() {
        this.field_70180_af.func_187227_b(IS_AFFECTED_BY_IMBUING, (Object)true);
    }

    public void setAffectedByHardening() {
        this.field_70180_af.func_187227_b(IS_AFFECTED_BY_HARDENING, (Object)true);
    }

    public void setHurtThrower() {
        this.canHurtThrower = true;
    }

    public boolean isPhysical() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_PHYSICAL);
    }

    public boolean isAffectedByHaki() {
        return this.isAffectedByHardening() || this.isAffectedByImbuing();
    }

    public boolean isAffectedByHardening() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_AFFECTED_BY_HARDENING);
    }

    public boolean isAffectedByImbuing() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_AFFECTED_BY_IMBUING);
    }

    public void setPassThroughBlocks() {
        this.canPassThroughBlocks = true;
    }

    public void setArmorPiercing() {
        this.armorPiercing = true;
    }

    public void setPassThroughEntities() {
        this.canPassThroughEntities = true;
    }

    public void setCanGetStuckInGround() {
        this.canGetStuckInGround = true;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public boolean isStuckInGround() {
        return this.stuckInGround;
    }

    public void setChangeHurtTime(boolean flag) {
        this.changeHurtTime = flag;
    }

    public void setHurtTime(int time) {
        this.hurtTime = time;
    }

    public void setTargetResetTime(int time) {
        this.targetResetTime = time;
    }

    public int getTargetResetTime() {
        return this.targetResetTime;
    }

    public static interface IWithEffects
    extends Serializable {
        public EffectInstance[] getEffects();
    }

    public static interface IOnTick
    extends Serializable {
        public void onTick();
    }

    public static interface IOnBlockImpact
    extends Serializable {
        public void onImpact(BlockPos var1);
    }

    public static interface IOnEntityImpact
    extends Serializable {
        public void onImpact(LivingEntity var1);
    }
}

