/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.abilities.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.models.CubeModel;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.IFlexibleSizeProjectile;

@OnlyIn(value=Dist.CLIENT)
public class GlowingAbilityProjectileRenderer<T extends AbilityProjectileEntity>
extends EntityRenderer<T> {
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float scaleZ = 1.0f;
    private float red;
    private float blue;
    private float green;
    private float alpha;
    private EntityModel model;
    private ResourceLocation texture;

    public GlowingAbilityProjectileRenderer(EntityRendererManager renderManager, EntityModel model) {
        super(renderManager);
        this.model = model;
    }

    public void setTexture(ResourceLocation res) {
        this.texture = res;
    }

    public void setColor(double red, double green, double blue, double alpha) {
        this.red = (float)red;
        this.green = (float)green;
        this.blue = (float)blue;
        this.alpha = (float)alpha;
    }

    public void setScale(double scaleX, double scaleY, double scaleZ) {
        this.scaleX = (float)scaleX;
        this.scaleY = (float)scaleY;
        this.scaleZ = (float)scaleZ;
    }

    public Vec3d getScale() {
        return new Vec3d((double)this.scaleX, (double)this.scaleY, (double)this.scaleZ);
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (((AbilityProjectileEntity)((Object)entity)).field_70173_aa < 2) {
            return;
        }
        if (entity instanceof IFlexibleSizeProjectile) {
            this.setScale(((IFlexibleSizeProjectile)entity).getSize(), ((IFlexibleSizeProjectile)entity).getSize(), ((IFlexibleSizeProjectile)entity).getSize());
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, ((AbilityProjectileEntity)((Object)entity)).field_70126_B + (((AbilityProjectileEntity)((Object)entity)).field_70177_z - ((AbilityProjectileEntity)((Object)entity)).field_70126_B) * partialTicks - 180.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, ((AbilityProjectileEntity)((Object)entity)).field_70127_C + (((AbilityProjectileEntity)((Object)entity)).field_70125_A - ((AbilityProjectileEntity)((Object)entity)).field_70127_C) * partialTicks, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
        matrixStack.func_227862_a_(this.scaleX, this.scaleY, this.scaleZ);
        ResourceLocation finalTexture = this.getEntityTexture((AbilityProjectileEntity)((Object)entity));
        RenderType type = finalTexture == null ? ModRenderTypes.getEnergyRenderType() : RenderType.func_228644_e_((ResourceLocation)finalTexture);
        if (this.model != null) {
            this.model.func_225598_a_(matrixStack, buffer.getBuffer(type), packedLight, OverlayTexture.field_229196_a_, this.red, this.green, this.blue, this.alpha);
        }
        matrixStack.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(AbilityProjectileEntity entity) {
        if (entity.func_85052_h() != null && entity.isAffectedByHaki()) {
            boolean hardeningCheck;
            boolean bl = hardeningCheck = entity.isAffectedByHardening() && HakiHelper.hasHardeningActive(entity.func_85052_h());
            if (hardeningCheck) {
                return ModResources.BUSOSHOKU_HAKI_ARM;
            }
        }
        return this.texture;
    }

    public static class Factory
    implements IRenderFactory<AbilityProjectileEntity> {
        protected EntityModel model = new CubeModel();
        protected double scaleX = 1.0;
        protected double scaleY = 1.0;
        protected double scaleZ = 1.0;
        protected double red = 255.0;
        protected double green = 255.0;
        protected double blue = 255.0;
        protected double alpha = 255.0;
        protected ResourceLocation texture;

        public Factory(EntityModel model) {
            this.model = model;
        }

        public Factory setTexture(String textureName) {
            this.texture = new ResourceLocation(APIConfig.projectId, "textures/models/projectiles/" + textureName + ".png");
            return this;
        }

        public Factory setTexture(ResourceLocation location) {
            this.texture = location;
            return this;
        }

        public Factory setColor(double red, double green, double blue, double alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            return this;
        }

        public Factory setColor(String hex) {
            Color color = WyHelper.hexToRGB(hex);
            this.red = color.getRed();
            this.green = color.getGreen();
            this.blue = color.getBlue();
            this.alpha = color.getAlpha();
            return this;
        }

        public Factory setAlpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Factory setScale(double scale) {
            this.scaleY = this.scaleZ = scale;
            this.scaleX = this.scaleZ;
            return this;
        }

        public Factory setScale(double scaleX, double scaleY, double scaleZ) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.scaleZ = scaleZ;
            return this;
        }

        public EntityRenderer<? super AbilityProjectileEntity> createRenderFor(EntityRendererManager manager) {
            GlowingAbilityProjectileRenderer renderer = new GlowingAbilityProjectileRenderer(manager, this.model);
            renderer.setTexture(this.texture);
            renderer.setScale(this.scaleX, this.scaleY, this.scaleZ);
            renderer.setColor(this.red, this.green, this.blue, this.alpha);
            return renderer;
        }
    }
}

