/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.abilities.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.abilities.renderers.AbilityProjectileRenderer;

@OnlyIn(value=Dist.CLIENT)
public class StretchingProjectileRenderer<T extends AbilityProjectileEntity, M extends EntityModel<T>>
extends AbilityProjectileRenderer<T, M> {
    private M stretchModel;
    private float stretchScaleX = 1.0f;
    private float stretchScaleY = 1.0f;
    private float stretchScaleZ = 1.0f;

    public StretchingProjectileRenderer(EntityRendererManager renderManager, M model, M stretchModel) {
        super(renderManager, model);
        this.stretchModel = stretchModel;
    }

    public void setStretchScale(double scaleX, double scaleY, double scaleZ) {
        this.stretchScaleX = (float)scaleX;
        this.stretchScaleY = (float)scaleY;
        this.stretchScaleZ = (float)scaleZ;
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (((AbilityProjectileEntity)((Object)entity)).field_70173_aa < 2) {
            return;
        }
        if (((AbilityProjectileEntity)((Object)entity)).func_85052_h() == null || !((AbilityProjectileEntity)((Object)entity)).func_85052_h().func_70089_S()) {
            ((AbilityProjectileEntity)((Object)entity)).func_70106_y();
            return;
        }
        Vec3d originPos = ((AbilityProjectileEntity)((Object)entity)).func_85052_h().func_213303_ch();
        Vec3d entityPos = new Vec3d(MathHelper.func_219803_d((double)partialTicks, (double)((AbilityProjectileEntity)((Object)entity)).field_70169_q, (double)entity.func_226277_ct_()), MathHelper.func_219803_d((double)partialTicks, (double)((AbilityProjectileEntity)((Object)entity)).field_70167_r, (double)entity.func_226278_cu_()), MathHelper.func_219803_d((double)partialTicks, (double)((AbilityProjectileEntity)((Object)entity)).field_70166_s, (double)entity.func_226281_cx_()));
        Vec3d stretchVec = entityPos.func_178788_d(originPos);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, ((AbilityProjectileEntity)((Object)entity)).field_70126_B + (((AbilityProjectileEntity)((Object)entity)).field_70177_z - ((AbilityProjectileEntity)((Object)entity)).field_70126_B) * partialTicks - 180.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, ((AbilityProjectileEntity)((Object)entity)).field_70127_C + (((AbilityProjectileEntity)((Object)entity)).field_70125_A - ((AbilityProjectileEntity)((Object)entity)).field_70127_C) * partialTicks, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
        float modelLength = 0.5f;
        float modelOffset = 0.25f;
        float stretchLength = (float)stretchVec.func_72433_c();
        matrixStack.func_227861_a_(0.0, 0.0, (double)(-modelOffset));
        matrixStack.func_227862_a_(this.stretchScaleX, this.stretchScaleY, (stretchLength + 2.0f * modelOffset) / modelLength);
        matrixStack.func_227861_a_(0.0, 0.0, (double)modelOffset);
        ResourceLocation finalTexture = this.getEntityTexture((AbilityProjectileEntity)((Object)entity));
        RenderType type = finalTexture == null ? ModRenderTypes.TRANSPARENT_COLOR : RenderType.func_228644_e_((ResourceLocation)finalTexture);
        if (this.stretchModel != null) {
            this.stretchModel.func_225598_a_(matrixStack, buffer.getBuffer(type), packedLight, OverlayTexture.field_229196_a_, (float)this.getRGB().getRed() / 255.0f, (float)this.getRGB().getGreen() / 255.0f, (float)this.getRGB().getBlue() / 255.0f, (float)this.getRGB().getAlpha() / 255.0f);
        }
        matrixStack.func_227865_b_();
        super.render(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public static class Factory
    extends AbilityProjectileRenderer.Factory {
        private EntityModel stretchModel;
        protected double stretchScaleX = 1.0;
        protected double stretchScaleY = 1.0;
        protected double stretchScaleZ = 1.0;

        public Factory(EntityModel model, EntityModel stretchModel) {
            super(model);
            this.stretchModel = stretchModel;
        }

        public Factory setStretchScale(double scaleX, double scaleY, double scaleZ) {
            this.stretchScaleX = scaleX;
            this.stretchScaleY = scaleY;
            this.stretchScaleZ = scaleZ;
            return this;
        }

        @Override
        public EntityRenderer<? super AbilityProjectileEntity> createRenderFor(EntityRendererManager manager) {
            StretchingProjectileRenderer renderer = new StretchingProjectileRenderer(manager, this.model, this.stretchModel);
            renderer.setTexture(this.texture);
            renderer.setStretchScale(this.stretchScaleX, this.stretchScaleY, this.stretchScaleZ);
            renderer.setScale(this.scaleX, this.scaleY, this.scaleZ);
            renderer.setColor(this.red, this.green, this.blue, this.alpha);
            return renderer;
        }
    }
}

