/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.data.ability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PassiveAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class AbilityDataBase
implements IAbilityData {
    private List<Ability> unlockedAbilities = new ArrayList<Ability>();
    private Ability[] equippedAbilities = new Ability[128];
    private Ability previouslyUsedAbility;
    private int currentCombatBarSet = 0;

    @Override
    public boolean addUnlockedAbility(Ability abl) {
        Ability ogAbl = this.getUnlockedAbility(abl);
        if (ogAbl == null) {
            this.unlockedAbilities.add(abl);
            return true;
        }
        return false;
    }

    @Override
    public boolean setUnlockedAbility(int slot, Ability abl) {
        Ability ogAbl = this.getUnlockedAbility(abl);
        if (ogAbl == null) {
            if (this.unlockedAbilities.size() > slot) {
                this.unlockedAbilities.set(slot, abl);
            } else {
                this.unlockedAbilities.add(slot, abl);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeUnlockedAbility(Ability abl) {
        Ability ogAbl = this.getUnlockedAbility(abl);
        if (ogAbl != null) {
            this.unlockedAbilities.remove((Object)ogAbl);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUnlockedAbility(Ability abl) {
        this.unlockedAbilities.removeIf(ability -> ability == null);
        return this.unlockedAbilities.parallelStream().anyMatch(ability -> ability.equals((Object)abl));
    }

    @Override
    public <T extends Ability> T getUnlockedAbility(T abl) {
        this.unlockedAbilities.removeIf(ability -> ability == null);
        return (T)((Object)((Ability)this.unlockedAbilities.parallelStream().filter(ability -> ability.equals((Object)abl)).findFirst().orElse(null)));
    }

    @Override
    public <T extends Ability> T getUnlockedAbility(int slot) {
        this.unlockedAbilities.removeIf(ability -> ability == null);
        return (T)((Object)(this.unlockedAbilities.size() > slot ? this.unlockedAbilities.get(slot) : null));
    }

    @Override
    public <T extends Ability> List<T> getUnlockedAbilities(APIConfig.AbilityCategory category) {
        this.unlockedAbilities.removeIf(ability -> ability == null);
        return this.unlockedAbilities.parallelStream().filter(ability -> ability.getCategory() == category || category == APIConfig.AbilityCategory.ALL).collect(Collectors.toList());
    }

    @Override
    public void clearUnlockedAbilities(APIConfig.AbilityCategory category) {
        this.unlockedAbilities.removeIf(ability -> ability == null);
        this.unlockedAbilities.removeIf(ability -> ability.getCategory() == category || category == APIConfig.AbilityCategory.ALL);
    }

    @Override
    public void clearUnlockedAbilities(Predicate<Ability> check) {
        this.unlockedAbilities.removeIf(ability -> ability == null);
        this.unlockedAbilities.removeIf(check);
    }

    @Override
    public void clearUnlockedAbilityFromList(APIConfig.AbilityCategory category, List<Ability> list) {
        this.unlockedAbilities.removeIf(ability -> (ability == null || ability.getCategory() == category || category == APIConfig.AbilityCategory.ALL) && list.contains(ability));
    }

    @Override
    public int countUnlockedAbilities(APIConfig.AbilityCategory category) {
        this.unlockedAbilities.removeIf(ability -> ability == null);
        return this.unlockedAbilities.parallelStream().filter(ability -> !(ability instanceof PassiveAbility)).filter(ability -> ability.getCategory() == category || category == APIConfig.AbilityCategory.ALL).collect(Collectors.toList()).size();
    }

    @Override
    public boolean addEquippedAbility(Ability abl) {
        for (int i = 0; i < this.equippedAbilities.length; ++i) {
            Ability ability = this.equippedAbilities[i];
            if (ability != null) continue;
            this.equippedAbilities[i] = abl;
            return true;
        }
        return false;
    }

    @Override
    public boolean setEquippedAbility(int slot, Ability abl) {
        Ability ogAbl = this.getEquippedAbility(abl);
        if (ogAbl == null && slot <= 8 * CommonConfig.INSTANCE.getAbilityBars()) {
            this.equippedAbilities[slot] = abl;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEquippedAbility(Ability abl) {
        Ability ogAbl = this.getUnlockedAbility(abl);
        if (ogAbl != null) {
            for (int i = 0; i < this.equippedAbilities.length; ++i) {
                Ability ability = this.equippedAbilities[i];
                if (ability == null) continue;
                this.equippedAbilities[i] = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasEquippedAbility(Ability abl) {
        return ((Stream)Arrays.stream(this.equippedAbilities).parallel()).filter(ability -> ability != null).anyMatch(ability -> ability.equals((Object)abl));
    }

    @Override
    public int getEquippedAbilitySlot(Ability abl) {
        for (int i = 0; i < this.equippedAbilities.length; ++i) {
            Ability ability = this.equippedAbilities[i];
            if (ability == null || !ability.equals((Object)abl)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public <T extends Ability> T getEquippedAbility(T abl) {
        return (T)((Object)((Ability)((Stream)Arrays.stream(this.equippedAbilities).parallel()).filter(ability -> ability != null).filter(ability -> ability.equals((Object)abl)).findFirst().orElse(null)));
    }

    @Override
    public <T extends Ability> T getEquippedAbility(int slot) {
        return (T)((Object)this.equippedAbilities[slot]);
    }

    @Override
    public <T extends Ability> T[] getEquippedAbilities() {
        return this.equippedAbilities;
    }

    @Override
    public <T extends Ability> T[] getEquippedAbilities(Predicate<Ability> check) {
        Stream<Ability> stream = Arrays.stream(this.equippedAbilities);
        stream = stream.filter(ability -> ability != null);
        stream = stream.filter(check);
        List<Ability> list1 = stream.collect(Collectors.toList());
        Ability[] list2 = new Ability[list1.size()];
        return list1.toArray(list2);
    }

    @Override
    public <T extends Ability> T[] getEquippedAbilities(APIConfig.AbilityCategory category) {
        List<Ability> list1 = Arrays.stream(this.equippedAbilities).filter(ability -> ability != null && ability.getCategory() == category || category == APIConfig.AbilityCategory.ALL).collect(Collectors.toList());
        Ability[] list2 = new Ability[list1.size()];
        return list1.toArray(list2);
    }

    @Override
    public void clearEquippedAbilities(Predicate<Ability> predicate) {
        for (int i = 0; i < this.equippedAbilities.length; ++i) {
            Ability ability = this.equippedAbilities[i];
            if (ability == null || !predicate.test(ability)) continue;
            this.equippedAbilities[i] = null;
        }
    }

    @Override
    public void clearEquippedAbilities(APIConfig.AbilityCategory category) {
        for (int i = 0; i < this.equippedAbilities.length; ++i) {
            Ability ability = this.equippedAbilities[i];
            if ((ability == null || ability.getCategory() != category) && category != APIConfig.AbilityCategory.ALL) continue;
            this.equippedAbilities[i] = null;
        }
    }

    @Override
    public void clearEquippedAbilityFromList(APIConfig.AbilityCategory category, List<Ability> list) {
        for (int i = 0; i < this.equippedAbilities.length; ++i) {
            Ability ability = this.equippedAbilities[i];
            if ((ability == null || ability.getCategory() != category || !list.contains((Object)ability)) && category == APIConfig.AbilityCategory.ALL) continue;
            this.equippedAbilities[i] = null;
        }
    }

    @Override
    public int countEquippedAbilities(APIConfig.AbilityCategory category) {
        return ((Stream)Arrays.stream(this.equippedAbilities).parallel()).filter(ability -> ability != null).filter(ability -> ability.getCategory() == category || category == APIConfig.AbilityCategory.ALL).filter(ability -> !(ability instanceof PassiveAbility)).collect(Collectors.toList()).size();
    }

    @Override
    public <T extends Ability> T getPreviouslyUsedAbility() {
        return (T)((Object)this.previouslyUsedAbility);
    }

    @Override
    public void setPreviouslyUsedAbility(Ability abl) {
        this.previouslyUsedAbility = abl;
    }

    @Override
    public int getCombatBarSet() {
        return this.currentCombatBarSet;
    }

    @Override
    public void nextCombatBarSet() {
        ++this.currentCombatBarSet;
    }

    @Override
    public void prevCombatBarSet() {
        --this.currentCombatBarSet;
    }

    @Override
    public void setCombatBarSet(int set) {
        this.currentCombatBarSet = set;
    }
}

