/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.data.ability;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PassiveAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataBase;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;

public class AbilityDataCapability {
    @CapabilityInject(value=IAbilityData.class)
    public static final Capability<IAbilityData> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IAbilityData.class, (Capability.IStorage)new Capability.IStorage<IAbilityData>(){

            public INBT writeNBT(Capability<IAbilityData> capability, IAbilityData instance, Direction side) {
                CompoundNBT props = new CompoundNBT();
                try {
                    CompoundNBT nbtAbility;
                    ListNBT unlockedAbilities = new ListNBT();
                    for (int i = 0; i < instance.getUnlockedAbilities(APIConfig.AbilityCategory.ALL).size(); ++i) {
                        Ability ability = (Ability)((Object)instance.getUnlockedAbilities(APIConfig.AbilityCategory.ALL).get(i));
                        String name = WyHelper.getResourceName(ability.getName());
                        nbtAbility = new CompoundNBT();
                        nbtAbility.func_74778_a("name", name);
                        nbtAbility.func_74778_a("displayName", WyHelper.isNullOrEmpty(ability.getDisplayName()) ? "" : ability.getDisplayName());
                        nbtAbility.func_74768_a("pool", ability.getPoolId());
                        nbtAbility.func_74778_a("unlock", ability.getUnlockType().name());
                        if (ability instanceof PassiveAbility) {
                            nbtAbility.func_74757_a("isPaused", ((PassiveAbility)ability).isPaused());
                        }
                        unlockedAbilities.add((Object)nbtAbility);
                    }
                    props.func_218657_a("unlocked_abilities", (INBT)unlockedAbilities);
                    ListNBT equippedAbilities = new ListNBT();
                    for (int i = 0; i < instance.getEquippedAbilities().length; ++i) {
                        Ability ability = instance.getEquippedAbilities()[i];
                        if (ability != null) {
                            String name = WyHelper.getResourceName(ability.getName());
                            CompoundNBT nbtAbility2 = new CompoundNBT();
                            nbtAbility2.func_74778_a("name", name);
                            nbtAbility2.func_74778_a("displayName", ability.getDisplayName() == null ? "" : ability.getDisplayName());
                            nbtAbility2.func_74768_a("pos", i);
                            nbtAbility2.func_74778_a("state", ability.getState().toString());
                            nbtAbility2.func_74768_a("pool", ability.getPoolId());
                            nbtAbility2.func_74780_a("cooldown", ability.getCooldown());
                            nbtAbility2.func_74780_a("maxCooldown", ability.getMaxCooldown());
                            if (ability instanceof ContinuousAbility) {
                                nbtAbility2.func_74780_a("continueTimer", (double)((ContinuousAbility)ability).getContinueTime());
                                nbtAbility2.func_74780_a("threshold", (double)((ContinuousAbility)ability).getThreshold());
                            }
                            if (ability instanceof ChargeableAbility) {
                                nbtAbility2.func_74780_a("chargeTimer", (double)((ChargeableAbility)ability).getChargeTime());
                            }
                            equippedAbilities.add((Object)nbtAbility2);
                            continue;
                        }
                        nbtAbility = new CompoundNBT();
                        nbtAbility.func_74768_a("pos", i);
                        equippedAbilities.add((Object)nbtAbility);
                    }
                    props.func_218657_a("equipped_abilities", (INBT)equippedAbilities);
                    props.func_74768_a("combat_bar_set", instance.getCombatBarSet());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return props;
            }

            public void readNBT(Capability<IAbilityData> capability, IAbilityData instance, Direction side, INBT nbt) {
                CompoundNBT props = (CompoundNBT)nbt;
                try {
                    instance.clearEquippedAbilities(APIConfig.AbilityCategory.ALL);
                    instance.clearUnlockedAbilities(APIConfig.AbilityCategory.ALL);
                    ListNBT unlockedAbilities = props.func_150295_c("unlocked_abilities", 10);
                    for (int i = 0; i < unlockedAbilities.size(); ++i) {
                        CompoundNBT nbtAbility = unlockedAbilities.func_150305_b(i);
                        try {
                            Ability ability2 = ((Ability)GameRegistry.findRegistry(Ability.class).getValue(new ResourceLocation(APIConfig.projectId, nbtAbility.func_74779_i("name")))).create();
                            if (ability2 == null) continue;
                            int poolId = nbtAbility.func_74762_e("pool");
                            ability2.setInPool(poolId);
                            AbilityUnlock unlockType = AbilityUnlock.valueOf(nbtAbility.func_74779_i("unlock"));
                            ability2.setUnlockType(unlockType);
                            String displayName = nbtAbility.func_74779_i("displayName");
                            ability2.setDisplayName(displayName);
                            if (ability2 instanceof PassiveAbility) {
                                ((PassiveAbility)ability2).setPause(nbtAbility.func_74767_n("isPaused"));
                            }
                            instance.addUnlockedAbility(ability2);
                            continue;
                        }
                        catch (Exception e) {
                            WyDebug.debug("Unregistered ability: " + nbtAbility.func_74779_i("name"));
                        }
                    }
                    ListNBT equippedAbilities = props.func_150295_c("equipped_abilities", 10);
                    List activeAbilitiesUnlocked = instance.getUnlockedAbilities(APIConfig.AbilityCategory.ALL).parallelStream().filter(ability -> !(ability instanceof PassiveAbility)).collect(Collectors.toList());
                    for (int i = 0; i < equippedAbilities.size(); ++i) {
                        CompoundNBT nbtAbility = equippedAbilities.func_150305_b(i);
                        Ability ability3 = (Ability)GameRegistry.findRegistry(Ability.class).getValue(new ResourceLocation(APIConfig.projectId, nbtAbility.func_74779_i("name")));
                        if (ability3 != null) {
                            for (Ability abl : activeAbilitiesUnlocked) {
                                if (!abl.equals((Object)ability3)) continue;
                                Ability.State state = Ability.State.valueOf(nbtAbility.func_74779_i("state"));
                                int cooldown = (int)(nbtAbility.func_74769_h("cooldown") / 20.0);
                                int maxCooldown = (int)(nbtAbility.func_74769_h("maxCooldown") / 20.0);
                                int pos = nbtAbility.func_74762_e("pos");
                                int poolId = nbtAbility.func_74762_e("pool");
                                String displayName = nbtAbility.func_74779_i("displayName");
                                if (state == null) {
                                    state = Ability.State.STANDBY;
                                }
                                abl.setState(state);
                                abl.setMaxCooldown(maxCooldown);
                                abl.setCooldown(cooldown);
                                abl.setInPool(poolId);
                                abl.setDisplayName(displayName);
                                if (abl instanceof ContinuousAbility) {
                                    int continueTime = (int)(nbtAbility.func_74769_h("continueTime") / 20.0);
                                    ((ContinuousAbility)abl).setContinueTime(continueTime);
                                    int threshold = (int)(nbtAbility.func_74769_h("threshold") / 20.0);
                                    ((ContinuousAbility)abl).setThreshold(threshold);
                                }
                                if (abl instanceof ChargeableAbility) {
                                    int chargeTime = (int)(nbtAbility.func_74769_h("chargeTime") / 20.0);
                                    ((ChargeableAbility)abl).setChargeTime(chargeTime);
                                }
                                instance.setEquippedAbility(pos, abl);
                            }
                            continue;
                        }
                        if (ability3 != null) continue;
                        int pos = nbtAbility.func_74762_e("pos");
                        instance.setEquippedAbility(pos, null);
                    }
                    instance.setCombatBarSet(props.func_74762_e("combat_bar_set"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, AbilityDataBase::new);
    }

    public static IAbilityData get(LivingEntity entity) {
        return (IAbilityData)entity.getCapability(INSTANCE, null).orElse((Object)new AbilityDataBase());
    }

    public static LazyOptional<IAbilityData> getLazy(LivingEntity entity) {
        return entity.getCapability(INSTANCE, null);
    }
}

