/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.math;

import java.util.Hashtable;
import xyz.pixelatedw.mineminenomi.wypi.math.Circle;
import xyz.pixelatedw.mineminenomi.wypi.math.ICircle;
import xyz.pixelatedw.mineminenomi.wypi.math.ISphere;

public class Sphere {
    private static SphereGenerator instance = new SphereGenerator();

    public static void generate(int x0, int y0, int z0, int radius, ISphere callback) {
        instance.pregenerate(x0, y0, z0, callback, false);
        Circle.generate(x0, z0, radius, instance);
    }

    public static void generateFilled(int x0, int y0, int z0, int radius, ISphere callback) {
        instance.pregenerate(x0, y0, z0, callback, true);
        Circle.generate(x0, z0, radius, instance);
    }

    private static class SphereGenerator
    implements ICircle {
        private Hashtable<String, Boolean> mTouched = new Hashtable();
        private ISphere mCallback;
        private int mX0;
        private int mY0;
        private int mZ0;
        private int mTemp;
        private boolean mFilled;

        private SphereGenerator() {
        }

        public void pregenerate(int x0, int y0, int z0, ISphere callback, boolean filled) {
            this.mX0 = x0;
            this.mY0 = y0;
            this.mZ0 = z0;
            this.mCallback = callback;
            this.mTouched.clear();
            this.mFilled = filled;
        }

        @Override
        public void call(int x1, int z1) {
            this.mTemp = z1;
            Circle.generate(0, this.mY0, x1 - this.mX0, new ICircle(){

                @Override
                public void call(int x2, int y2) {
                    this.updateBlock(mX0 + x2, y2, mTemp);
                }
            });
            this.mTemp = x1;
            if (this.mFilled) {
                Circle.generateFilled(0, this.mY0, z1 - this.mZ0, new ICircle(){

                    @Override
                    public void call(int x2, int y2) {
                        this.updateBlock(mTemp, y2, mZ0 + x2);
                    }
                });
            } else {
                Circle.generate(0, this.mY0, z1 - this.mZ0, new ICircle(){

                    @Override
                    public void call(int x2, int y2) {
                        this.updateBlock(mTemp, y2, mZ0 + x2);
                    }
                });
            }
        }

        private void updateBlock(int x, int y, int z) {
            String key = x + " " + y + "  " + z;
            if (this.mTouched.containsKey(key)) {
                return;
            }
            this.mTouched.put(key, true);
            this.mCallback.call(x, y, z);
        }
    }
}

