/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.network.packets.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class SSyncAbilityDataPacket {
    private int entityId;
    private INBT data;

    public SSyncAbilityDataPacket() {
    }

    public SSyncAbilityDataPacket(int entityId, IAbilityData abiltiyDataProps) {
        this.data = new CompoundNBT();
        this.data = AbilityDataCapability.INSTANCE.getStorage().writeNBT(AbilityDataCapability.INSTANCE, (Object)abiltiyDataProps, null);
        this.entityId = entityId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_150786_a((CompoundNBT)this.data);
    }

    public static SSyncAbilityDataPacket decode(PacketBuffer buffer) {
        SSyncAbilityDataPacket msg = new SSyncAbilityDataPacket();
        msg.entityId = buffer.readInt();
        msg.data = buffer.func_150793_b();
        return msg;
    }

    public static void handle(SSyncAbilityDataPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSyncAbilityDataPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            IAbilityData props = AbilityDataCapability.get((LivingEntity)target);
            AbilityDataCapability.INSTANCE.getStorage().readNBT(AbilityDataCapability.INSTANCE, (Object)props, null, message.data);
        }
    }
}

