/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.nbt;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipe;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeFactory;
import de.geheimagentnr1.recipes_lib.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class NBTRecipeSerializer<R extends NBTRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<R> {
    protected static final int MAX_WIDTH = 3;
    protected static final int MAX_HEIGHT = 3;

    @Nonnull
    public R read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        Pair<NonNullList<Ingredient>, NBTRecipeFactory<R>> recipeData = this.readRecipeData(json);
        JsonObject resultJson = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        ItemStack result = ShapedRecipe.func_199798_a((JsonObject)resultJson);
        try {
            result.func_196082_o().func_197643_a(JsonToNBT.func_180713_a((String)JSONUtils.func_151200_h((JsonObject)resultJson, (String)"nbt")));
        }
        catch (CommandSyntaxException exception) {
            throw new IllegalStateException(exception);
        }
        boolean merge_nbt = JSONUtils.func_151212_i((JsonObject)resultJson, (String)"merge_nbt");
        return recipeData.getValue().buildRecipe(recipeId, group, recipeData.getKey(), result, merge_nbt);
    }

    @Nonnull
    protected abstract Pair<NonNullList<Ingredient>, NBTRecipeFactory<R>> readRecipeData(@Nonnull JsonObject var1);

    @Nullable
    public R read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        Pair<Integer, NBTRecipeFactory<R>> recipeData = this.readRecipeData(buffer);
        String group = buffer.func_218666_n();
        NonNullList ingredients = NonNullList.func_191197_a((int)recipeData.getKey(), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack result = buffer.func_150791_c();
        boolean merge_nbt = buffer.readBoolean();
        return recipeData.getValue().buildRecipe(recipeId, group, (NonNullList<Ingredient>)ingredients, result, merge_nbt);
    }

    @Nonnull
    protected abstract Pair<Integer, NBTRecipeFactory<R>> readRecipeData(@Nonnull PacketBuffer var1);

    public void write(@Nonnull PacketBuffer buffer, @Nonnull R recipe) {
        this.writeRecipeData(buffer, recipe);
        buffer.func_180714_a(((NBTRecipe)recipe).func_193358_e());
        for (Ingredient ingredient : ((NBTRecipe)recipe).func_192400_c()) {
            ingredient.func_199564_a(buffer);
        }
        buffer.func_150788_a(((NBTRecipe)recipe).func_77571_b());
        buffer.writeBoolean(((NBTRecipe)recipe).isMergeNbt());
    }

    protected abstract void writeRecipeData(@Nonnull PacketBuffer var1, @Nonnull R var2);
}

