/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shaped_nbt;

import de.geheimagentnr1.recipes_lib.elements.recipes.RecipeSerializers;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipe;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ShapedNBTRecipe
extends NBTRecipe
implements IShapedRecipe<CraftingInventory> {
    public static final String registry_name = "crafting_shaped_nbt";
    private final int recipeWidth;
    private final int recipeHeight;

    ShapedNBTRecipe(ResourceLocation id, String group, NonNullList<Ingredient> ingredients, ItemStack result, boolean merge_nbt, int _recipeWidth, int _recipeHeight) {
        super(id, group, ingredients, result, merge_nbt);
        this.recipeWidth = _recipeWidth;
        this.recipeHeight = _recipeHeight;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.SHAPED_NBT;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.recipeWidth && height >= this.recipeHeight;
    }

    public boolean matches(CraftingInventory inv, @Nonnull World worldIn) {
        for (int x = 0; x <= inv.func_174922_i() - this.recipeWidth; ++x) {
            for (int y = 0; y <= inv.func_174923_h() - this.recipeHeight; ++y) {
                if (this.checkMatch(inv, x, y, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingInventory craftingInventory, int x0, int y0, boolean turned) {
        NonNullList<Ingredient> ingredients = this.func_192400_c();
        for (int x = 0; x < craftingInventory.func_174922_i(); ++x) {
            for (int y = 0; y < craftingInventory.func_174923_h(); ++y) {
                int dx = x - x0;
                int dy = y - y0;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (dx >= 0 && dy >= 0 && dx < this.recipeWidth && dy < this.recipeHeight) {
                    ingredient = turned ? (Ingredient)ingredients.get(this.recipeWidth - dx - 1 + dy * this.recipeWidth) : (Ingredient)ingredients.get(dx + dy * this.recipeWidth);
                }
                if (ingredient.test(craftingInventory.func_70301_a(x + y * craftingInventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    public int getRecipeHeight() {
        return this.recipeHeight;
    }
}

