/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.annotations.BracketResolver;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.logger.LogLevel;
import com.blamejared.crafttweaker.api.mods.MCMods;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.expands.IDataRewrites;
import com.blamejared.crafttweaker.api.zencode.impl.FileAccessSingle;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.logger.FileLogger;
import com.blamejared.crafttweaker.impl.logger.GroupLogger;
import com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.openzen.zencode.java.JavaNativeModule;
import org.openzen.zencode.java.ScriptingEngine;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.ScriptBlock;
import org.openzen.zenscript.codemodel.SemanticModule;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.formatter.FileFormatter;
import org.openzen.zenscript.formatter.ScriptFormattingSettings;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.PrefixedBracketParser;
import org.openzen.zenscript.parser.SimpleBracketParser;
import org.openzen.zenscript.parser.expression.ParsedExpressionArray;
import org.openzen.zenscript.parser.expression.ParsedExpressionMap;

@ZenRegister
public class CraftTweakerAPI {
    public static final File SCRIPT_DIR = new File("scripts");
    @ZenCodeGlobals.Global
    public static ILogger logger;
    @ZenCodeGlobals.Global
    public static MCMods loadedMods;
    private static final List<IAction> ACTION_LIST;
    private static final List<IAction> ACTION_LIST_INVALID;
    private static ScriptingEngine SCRIPTING_ENGINE;
    public static boolean DEBUG_MODE;
    public static boolean NO_BRAND;
    private static boolean firstRun;

    public static void apply(IAction action) {
        if (!(action instanceof IRuntimeAction) && !CraftTweakerAPI.isFirstRun()) {
            return;
        }
        try {
            if (action.shouldApplyOn(EffectiveSide.get()) && action.validate(logger)) {
                String describe = action.describe();
                if (describe != null && !describe.isEmpty()) {
                    CraftTweakerAPI.logInfo(describe, new Object[0]);
                }
                action.apply();
                ACTION_LIST.add(action);
            } else {
                ACTION_LIST_INVALID.add(action);
            }
        }
        catch (Exception e) {
            CraftTweakerAPI.logThrowing("Error running action", e, new Object[0]);
        }
    }

    public static void reload() {
        ACTION_LIST.stream().filter(iAction -> iAction instanceof IUndoableAction).filter(iAction -> iAction.shouldApplyOn(EffectiveSide.get())).map(iAction -> (IUndoableAction)iAction).forEach(iUndoableAction -> {
            CraftTweakerAPI.logInfo(iUndoableAction.describeUndo(), new Object[0]);
            iUndoableAction.undo();
        });
        ACTION_LIST.removeIf(iAction -> iAction.shouldApplyOn(EffectiveSide.get()));
        ACTION_LIST_INVALID.clear();
        ((GroupLogger)logger).getPreviousMessages().clear();
    }

    private static void initEngine() {
        SCRIPTING_ENGINE = new ScriptingEngine(logger);
        CraftTweakerAPI.SCRIPTING_ENGINE.debug = DEBUG_MODE;
    }

    public static List<File> getScriptFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        CraftTweakerAPI.findScriptFiles(SCRIPT_DIR, fileList);
        return fileList;
    }

    public static void loadScripts(ScriptLoadingOptions scriptLoadingOptions) {
        NO_BRAND = false;
        List<File> fileList = CraftTweakerAPI.getScriptFiles();
        CraftTweakerAPI.logInfo("Started loading Scripts for Loader '%s'!", scriptLoadingOptions.getLoaderName());
        if (!scriptLoadingOptions.isExecute()) {
            CraftTweakerAPI.logInfo("This is only a syntax check. Script changes will not be applied.", new Object[0]);
        }
        Comparator<FileAccessSingle> comparator = FileAccessSingle.createComparator(CraftTweakerRegistry.getPreprocessors());
        SourceFile[] sourceFiles = (SourceFile[])fileList.stream().map(file -> new FileAccessSingle(SCRIPT_DIR, (File)file, scriptLoadingOptions, (Collection<IPreprocessor>)CraftTweakerRegistry.getPreprocessors())).filter(FileAccessSingle::shouldBeLoaded).sorted(comparator).map(FileAccessSingle::getSourceFile).toArray(SourceFile[]::new);
        CraftTweakerAPI.loadScripts(sourceFiles, scriptLoadingOptions);
        CraftTweakerAPI.logInfo("Finished loading Scripts!", new Object[0]);
    }

    public static void loadScripts(SourceFile[] sourceFiles, ScriptLoadingOptions scriptLoadingOptions) {
        try {
            CraftTweakerAPI.reload();
            CraftTweakerAPI.initEngine();
            JavaNativeModule crafttweakerModule = SCRIPTING_ENGINE.createNativeModule("crafttweaker", "crafttweaker", new JavaNativeModule[0]);
            LinkedList<JavaNativeModule> modules = new LinkedList<JavaNativeModule>();
            CraftTweakerRegistry.getClassesInPackage("crafttweaker").forEach(crafttweakerModule::addClass);
            CraftTweakerRegistry.getZenGlobals().forEach(crafttweakerModule::addGlobals);
            modules.add(crafttweakerModule);
            PrefixedBracketParser bep = new PrefixedBracketParser(null);
            for (Method method : CraftTweakerRegistry.getBracketResolvers()) {
                String name = method.getAnnotation(BracketResolver.class).value();
                FunctionalMemberRef memberRef = crafttweakerModule.loadStaticMethod(method);
                bep.register(name, new SimpleBracketParser(CraftTweakerAPI.SCRIPTING_ENGINE.registry, memberRef));
            }
            bep.register("recipetype", new RecipeTypeBracketHandler());
            crafttweakerModule.registerBEP(bep);
            SCRIPTING_ENGINE.registerNativeProvided(crafttweakerModule);
            for (String key : CraftTweakerRegistry.getRootPackages()) {
                if (key.equals("crafttweaker")) continue;
                JavaNativeModule module = SCRIPTING_ENGINE.createNativeModule(key, key, crafttweakerModule);
                CraftTweakerRegistry.getClassesInPackage(key).forEach(module::addClass);
                SCRIPTING_ENGINE.registerNativeProvided(module);
                modules.add(module);
            }
            JavaNativeModule expansions = SCRIPTING_ENGINE.createNativeModule("expansions", "", modules.toArray(new JavaNativeModule[0]));
            CraftTweakerRegistry.getExpansions().values().stream().flatMap(Collection::stream).forEach(expansions::addClass);
            SCRIPTING_ENGINE.registerNativeProvided(expansions);
            SemanticModule scripts = SCRIPTING_ENGINE.createScriptedModule("scripts", sourceFiles, (BracketExpressionParser)bep, FunctionParameter.NONE, compileError -> logger.error(compileError.toString()), validationLogEntry -> logger.error(validationLogEntry.toString()), sourceFile -> logger.info("Loading " + sourceFile.getFilename()), new String[0]);
            if (!scripts.isValid()) {
                logger.error("Scripts are invalid!");
                CraftTweaker.LOG.info("Scripts are invalid!");
                return;
            }
            if (scriptLoadingOptions.isFormat()) {
                List<HighLevelDefinition> all = scripts.definitions.getAll();
                ScriptFormattingSettings.Builder builder = new ScriptFormattingSettings.Builder();
                FileFormatter formatter = new FileFormatter(builder.build());
                List<ScriptBlock> blocks = scripts.scripts;
                for (ScriptBlock block : blocks) {
                    String format = formatter.format(scripts.rootPackage, block, all);
                    File parent = new File("scriptsFormatted");
                    File file = new File(parent, block.file.getFilename());
                    if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                        CraftTweakerAPI.logError("Could not find or create folder %s, aborting formatting task!", file.getParent());
                    }
                    file.createNewFile();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    writer.write(format);
                    writer.close();
                }
            }
            if (!scriptLoadingOptions.isExecute()) {
                return;
            }
            SCRIPTING_ENGINE.registerCompiled(scripts);
            SCRIPTING_ENGINE.run(Collections.emptyMap(), CraftTweaker.class.getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.throwingErr("Error running scripts", e);
        }
        CraftTweakerAPI.endFirstRun();
    }

    private static String getClassName(Class<?> cls) {
        return cls.isAnnotationPresent(ZenCodeType.Name.class) ? cls.getAnnotation(ZenCodeType.Name.class).value() : cls.getName();
    }

    public static void findScriptFiles(File path, List<File> files) {
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                if (file.isDirectory()) {
                    CraftTweakerAPI.findScriptFiles(file, files);
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(".zs")) continue;
                files.add(file);
            }
        }
    }

    public static void setupLoggers() {
        logger = new GroupLogger();
        ((GroupLogger)logger).addLogger(new FileLogger(new File("logs/crafttweaker.log")));
    }

    public static void logDump(String message, Object ... formats) {
        logger.log(LogLevel.INFO, String.format(message, formats), false);
    }

    public static void logInfo(String message, Object ... formats) {
        logger.info(String.format(message, formats));
    }

    public static void logDebug(String message, Object ... formats) {
        logger.debug(String.format(message, formats));
    }

    public static void logWarning(String message, Object ... formats) {
        logger.warning(String.format(message, formats));
    }

    public static void logError(String message, Object ... formats) {
        logger.error(String.format(message, formats));
    }

    public static void logThrowing(String message, Throwable e, Object ... formats) {
        logger.throwingErr(String.format(message, formats), e);
    }

    public static void log(LogLevel level, String filename, int lineNumber, String message, Object ... formats) {
        logger.log(level, String.format("[%s:%d%s]", filename, lineNumber, String.format(message, formats)));
    }

    public static List<IAction> getActionList() {
        return ImmutableList.copyOf(ACTION_LIST);
    }

    public static List<IAction> getActionListInvalid() {
        return ImmutableList.copyOf(ACTION_LIST_INVALID);
    }

    public static void endFirstRun() {
        firstRun = false;
    }

    public static boolean isFirstRun() {
        return firstRun;
    }

    public static ScriptingEngine getEngine() {
        if (SCRIPTING_ENGINE == null) {
            CraftTweakerAPI.initEngine();
        }
        return SCRIPTING_ENGINE;
    }

    public static String getDefaultLoaderName() {
        return "crafttweaker";
    }

    static {
        loadedMods = new MCMods();
        ACTION_LIST = new ArrayList<IAction>();
        ACTION_LIST_INVALID = new ArrayList<IAction>();
        DEBUG_MODE = false;
        NO_BRAND = false;
        firstRun = true;
        ParsedExpressionMap.compileOverrides.add(IDataRewrites::rewriteMap);
        ParsedExpressionArray.compileOverrides.add(IDataRewrites::rewriteArray);
    }
}

