/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.preprocessors;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.annotations.Preprocessor;
import com.blamejared.crafttweaker.api.logger.LogLevel;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.PreprocessorMatch;
import com.blamejared.crafttweaker.api.zencode.impl.FileAccessSingle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.ModList;

@Preprocessor
public class SnippingPreprocessor
implements IPreprocessor {
    private final List<Predicate<String[]>> headers = new ArrayList<Predicate<String[]>>(2);

    public SnippingPreprocessor() {
        this.headers.add(s -> "start".equals(s[0]));
        this.headers.add(s -> ((String[])s).length > 1 && "modnotloaded".equals(s[0]) && !ModList.get().isLoaded(s[1]));
    }

    @Override
    public String getName() {
        return "snip";
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    public boolean apply(@Nonnull FileAccessSingle file, ScriptLoadingOptions scriptLoadingOptions, @Nonnull List<PreprocessorMatch> preprocessorMatches) {
        TreeSet<Integer> starts = new TreeSet<Integer>();
        TreeSet<Integer> ends = new TreeSet<Integer>();
        block0: for (PreprocessorMatch preprocessorMatch : preprocessorMatches) {
            String[] content = preprocessorMatch.getContent().split(" ");
            if (content.length < 1) continue;
            for (Predicate<String[]> header : this.headers) {
                if (!header.test(content)) continue;
                starts.add(preprocessorMatch.getLine());
                continue block0;
            }
            if ("end".equals(content[0])) {
                ends.add(preprocessorMatch.getLine());
                continue;
            }
            CraftTweakerAPI.log(LogLevel.WARNING, file.getFileName(), preprocessorMatch.getLine(), "Invalid snip arguments: " + preprocessorMatch.getLine(), new Object[0]);
        }
        ListIterator<String> iterator = file.getFileContents().listIterator();
        int line = 0;
        boolean snipping = false;
        boolean snippingStarted = false;
        while (iterator.hasNext()) {
            int toChar;
            int fromChar;
            if (starts.contains(++line)) {
                snipping = true;
                snippingStarted = true;
            }
            StringBuilder lineContent = new StringBuilder(iterator.next());
            if (!snipping) continue;
            if (snippingStarted) {
                fromChar = lineContent.indexOf("#" + this.getName());
                snippingStarted = false;
            } else {
                fromChar = 0;
            }
            if (ends.contains(line)) {
                String statement = "#" + this.getName() + " end";
                toChar = lineContent.indexOf(statement) + statement.length();
                snipping = false;
            } else {
                toChar = lineContent.length();
            }
            String replaceWith = String.join((CharSequence)"", Collections.nCopies(toChar - fromChar, " "));
            iterator.set(lineContent.replace(fromChar, toChar, replaceWith).toString());
        }
        return true;
    }
}

