/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionCast;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.expression.ParsedExpressionString;
import org.openzen.zenscript.parser.expression.ParsedExpressionVariable;
import org.openzen.zenscript.parser.type.IParsedType;
import org.openzen.zenscript.parser.type.ParsedNamedType;
import org.openzen.zenscript.parser.type.ParsedStorageTag;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.RecipeTypeBracketHandler")
public class RecipeTypeBracketHandler
implements BracketExpressionParser {
    private static final Map<ResourceLocation, IRecipeManager> registeredTypes = new HashMap<ResourceLocation, IRecipeManager>();

    public static void registerRecipeManager(Class<?> managerClass) {
        IRecipeManager manager = null;
        try {
            manager = (IRecipeManager)managerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
        if (manager == null) {
            try {
                Optional<Field> any = Arrays.stream(managerClass.getDeclaredFields()).filter(f -> Modifier.isPublic(f.getModifiers())).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> f.getType().equals(managerClass)).findAny();
                if (any.isPresent()) {
                    manager = (IRecipeManager)any.get().get(null);
                }
            }
            catch (IllegalAccessException any) {
                // empty catch block
            }
        }
        if (manager == null) {
            try {
                Constructor<?> constructor = managerClass.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                manager = (IRecipeManager)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constructor) {
                // empty catch block
            }
        }
        if (manager == null) {
            CraftTweakerAPI.logError("Could not add RecipeManager for %s, please report to the author", managerClass);
            return;
        }
        ResourceLocation bracketResourceLocation = manager.getBracketResourceLocation();
        registeredTypes.put(bracketResourceLocation, manager);
    }

    private static IParsedType readParsedType(String name, CodePosition position) {
        List<ParsedNamedType.ParsedNamePart> collect = Arrays.stream(name.split("[.]")).map(s -> new ParsedNamedType.ParsedNamePart((String)s, null)).collect(Collectors.toList());
        return new ParsedNamedType(position, collect, ParsedStorageTag.NULL);
    }

    @Override
    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        StringBuilder builder = new StringBuilder();
        while (tokens.optional(ZSTokenType.T_GREATER) == null) {
            builder.append(((ZSToken)tokens.next()).content);
            builder.append(tokens.getLastWhitespace());
        }
        ResourceLocation resourceLocation = new ResourceLocation(builder.toString());
        if (registeredTypes.containsKey(resourceLocation)) {
            return this.getCall(builder.toString(), registeredTypes.get(resourceLocation), position);
        }
        return this.getCallFallback(builder.toString(), position);
    }

    private ParsedExpression getCallFallback(String location, CodePosition position) {
        ParsedExpressionVariable crafttweaker = new ParsedExpressionVariable(position, "crafttweaker", null);
        ParsedExpressionMember api = new ParsedExpressionMember(position, crafttweaker, "api", Collections.emptyList());
        ParsedExpressionMember bracketHandlers = new ParsedExpressionMember(position, api, "BracketHandlers", null);
        ParsedExpressionMember getRecipeManager = new ParsedExpressionMember(position, bracketHandlers, "getRecipeManager", null);
        return new ParsedExpressionCall(position, getRecipeManager, new ParsedCallArguments(Collections.emptyList(), Collections.singletonList(new ParsedExpressionString(position, location, false))));
    }

    private ParsedExpression getCall(String location, IRecipeManager manager, CodePosition position) {
        ParsedExpressionVariable crafttweaker = new ParsedExpressionVariable(position, "crafttweaker", null);
        ParsedExpressionMember api = new ParsedExpressionMember(position, crafttweaker, "api", Collections.emptyList());
        ParsedExpressionMember recipeTypeBracketHandler = new ParsedExpressionMember(position, api, "RecipeTypeBracketHandler", null);
        ParsedExpressionMember getRecipeManager = new ParsedExpressionMember(position, recipeTypeBracketHandler, "getRecipeManager", null);
        String nameContent = manager.getClass().getAnnotation(ZenCodeType.Name.class).value();
        IParsedType parsedType = RecipeTypeBracketHandler.readParsedType(nameContent, position);
        ParsedCallArguments arguments = new ParsedCallArguments(Collections.singletonList(parsedType), Collections.singletonList(new ParsedExpressionString(position, location, false)));
        ParsedExpressionCall parsedExpressionCall = new ParsedExpressionCall(position, getRecipeManager, arguments);
        return new ParsedExpressionCast(position, parsedExpressionCall, parsedType, false);
    }

    @ZenCodeType.Method
    public static <T extends IRecipeManager> T getRecipeManager(String location) {
        return (T)registeredTypes.get(new ResourceLocation(location));
    }
}

