/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.custom;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.commands.custom.MCAmbiguityConsumer;
import com.blamejared.crafttweaker.impl.commands.custom.MCArgumentBuilder;
import com.blamejared.crafttweaker.impl.commands.custom.MCCommand;
import com.blamejared.crafttweaker.impl.commands.custom.MCCommandContext;
import com.blamejared.crafttweaker.impl.commands.custom.MCCommandContextBuilder;
import com.blamejared.crafttweaker.impl.commands.custom.MCCommandSource;
import com.blamejared.crafttweaker.impl.commands.custom.MCLiteralCommandNode;
import com.blamejared.crafttweaker.impl.commands.custom.MCRedirectModifier;
import com.blamejared.crafttweaker.impl.commands.custom.MCRootCommandNode;
import com.blamejared.crafttweaker.impl.commands.custom.MCSuggestions;
import com.blamejared.crafttweaker.impl.commands.custom.MCSuggestionsBuilder;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.commands.custom.MCCommandNode")
public class MCCommandNode {
    private final CommandNode<CommandSource> internal;

    public static MCCommandNode convert(CommandNode<CommandSource> internal) {
        if (internal == null) {
            return null;
        }
        if (internal instanceof RootCommandNode) {
            return new MCRootCommandNode((RootCommandNode<CommandSource>)((RootCommandNode)internal));
        }
        if (internal instanceof LiteralCommandNode) {
            return new MCLiteralCommandNode((LiteralCommandNode<CommandSource>)((LiteralCommandNode)internal));
        }
        return new MCCommandNode(internal);
    }

    public MCCommandNode(CommandNode<CommandSource> internal) {
        this.internal = internal;
    }

    public CommandNode<CommandSource> getInternal() {
        return this.internal;
    }

    public MCCommand getCommand() {
        return new MCCommand((Command<CommandSource>)this.internal.getCommand());
    }

    public Collection<MCCommandNode> getChildren() {
        return this.internal.getChildren().stream().map(MCCommandNode::new).collect(Collectors.toList());
    }

    public MCCommandNode getChild(String name) {
        return MCCommandNode.convert((CommandNode<CommandSource>)this.internal.getChild(name));
    }

    public MCCommandNode getRedirect() {
        return MCCommandNode.convert((CommandNode<CommandSource>)this.internal.getRedirect());
    }

    public MCRedirectModifier getRedirectModifier() {
        return new MCRedirectModifier((RedirectModifier<CommandSource>)this.internal.getRedirectModifier());
    }

    public boolean canUse(MCCommandSource source) {
        return this.internal.canUse((Object)source.getInternal());
    }

    public void addChild(MCCommandNode node) {
        this.internal.addChild(node.internal);
    }

    public void findAmbiguities(MCAmbiguityConsumer consumer) {
        this.internal.findAmbiguities((parent, child, sibling, inputs) -> consumer.ambiguous(MCCommandNode.convert((CommandNode<CommandSource>)parent), MCCommandNode.convert((CommandNode<CommandSource>)child), MCCommandNode.convert((CommandNode<CommandSource>)sibling), inputs));
    }

    public Predicate<MCCommandSource> getRequirement() {
        return mcCommandSource -> this.internal.getRequirement().test(mcCommandSource.getInternal());
    }

    public String getName() {
        return this.internal.getName();
    }

    public String getUsageText() {
        return this.internal.getUsageText();
    }

    public void parse(String input, MCCommandContextBuilder contextBuilder) throws Exception {
        this.parse(new StringReader(input), contextBuilder);
    }

    public void parse(StringReader reader, MCCommandContextBuilder contextBuilder) throws Exception {
        this.internal.parse(reader, contextBuilder.getInternal());
    }

    public MCSuggestions listSuggestions(MCCommandContext context, MCSuggestionsBuilder builder) throws Exception {
        return new MCSuggestions(this.internal.listSuggestions(context.getInternal(), builder.getInternal()));
    }

    public MCArgumentBuilder createBuilder() {
        return MCArgumentBuilder.convert(this.internal.createBuilder());
    }

    public Collection<MCCommandNode> getRelevantNodes(String input) {
        return this.getRelevantNodes(new StringReader(input));
    }

    public Collection<MCCommandNode> getRelevantNodes(StringReader input) {
        return this.internal.getRelevantNodes(input).stream().map(MCCommandNode::new).collect(Collectors.toList());
    }

    public int compareTo(MCCommandNode o) {
        return this.internal.compareTo(o.internal);
    }

    public boolean isFork() {
        return this.internal.isFork();
    }

    public Collection<String> getExamples() {
        return this.internal.getExamples();
    }

    @ZenCodeType.Method
    public boolean equals(Object o) {
        return o instanceof MCCommandNode && this.internal.equals(((MCCommandNode)o).internal);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean opEquals(Object o) {
        return this.equals(o);
    }

    @ZenCodeType.Method
    public int hashCode() {
        return this.internal.hashCode();
    }

    @ZenCodeType.Method
    public String toString() {
        return this.internal.toString();
    }

    @ZenCodeType.Caster(implicit=true)
    public String asString() {
        return this.toString();
    }
}

