/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.events;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.events.IEvent;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.events.CTEventManager")
public class CTEventManager {
    @ZenCodeType.Method
    public static void register(final IEvent<?, ?> event) {
        final Consumer<?> consumer = event.getConsumer();
        CraftTweakerAPI.apply(new IUndoableAction(){

            @Override
            public void undo() {
                MinecraftForge.EVENT_BUS.unregister((Object)consumer);
            }

            @Override
            public String describeUndo() {
                return "Unregistering event listener for " + event.getName() + ".";
            }

            @Override
            public void apply() {
                MinecraftForge.EVENT_BUS.addListener(consumer);
            }

            @Override
            public String describe() {
                return "Registering event listener for " + event.getName() + ".";
            }
        });
    }
}

