/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.logger;

import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.logger.LogLevel;
import java.util.ArrayList;
import java.util.List;

public class GroupLogger
implements ILogger {
    private final List<ILogger> subLoggers = new ArrayList<ILogger>();
    private final List<LogMessage> previousMessages = new ArrayList<LogMessage>();

    public void addLogger(ILogger logger) {
        this.subLoggers.add(logger);
        this.previousMessages.forEach(logMessage -> logger.log(((LogMessage)logMessage).level, ((LogMessage)logMessage).message, ((LogMessage)logMessage).prefix));
    }

    public List<LogMessage> getPreviousMessages() {
        return this.previousMessages;
    }

    public List<ILogger> getSubLoggers() {
        return this.subLoggers;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        for (ILogger subLogger : this.subLoggers) {
            subLogger.setLogLevel(logLevel);
        }
    }

    @Override
    public LogLevel getLogLevel() {
        return this.subLoggers.stream().map(ILogger::getLogLevel).min(Enum::compareTo).orElse(LogLevel.DEBUG);
    }

    @Override
    public void log(LogLevel level, String message, boolean prefix) {
        for (ILogger logger : this.getSubLoggers()) {
            logger.log(level, message, prefix);
        }
        this.previousMessages.add(new LogMessage(level, message, prefix));
    }

    @Override
    public void log(LogLevel level, String message) {
        for (ILogger logger : this.getSubLoggers()) {
            logger.log(level, message);
        }
        this.previousMessages.add(new LogMessage(level, message, false));
    }

    @Override
    public void info(String message) {
        for (ILogger logger : this.getSubLoggers()) {
            logger.info(message);
        }
        this.previousMessages.add(new LogMessage(LogLevel.INFO, message, false));
    }

    @Override
    public void debug(String message) {
        for (ILogger logger : this.getSubLoggers()) {
            logger.debug(message);
        }
        this.previousMessages.add(new LogMessage(LogLevel.DEBUG, message, false));
    }

    @Override
    public void warning(String message) {
        for (ILogger logger : this.getSubLoggers()) {
            logger.warning(message);
        }
        this.previousMessages.add(new LogMessage(LogLevel.WARNING, message, false));
    }

    @Override
    public void error(String message) {
        for (ILogger logger : this.getSubLoggers()) {
            logger.error(message);
        }
        this.previousMessages.add(new LogMessage(LogLevel.ERROR, message, false));
    }

    @Override
    public void throwingWarn(String message, Throwable throwable) {
        for (ILogger logger : this.getSubLoggers()) {
            logger.throwingWarn(message, throwable);
        }
        this.previousMessages.add(new LogMessage(LogLevel.WARNING, message, false));
    }

    @Override
    public void throwingErr(String message, Throwable throwable) {
        for (ILogger logger : this.getSubLoggers()) {
            logger.throwingErr(message, throwable);
        }
        this.previousMessages.add(new LogMessage(LogLevel.ERROR, message, false));
    }

    private class LogMessage {
        private final LogLevel level;
        private final String message;
        private final boolean prefix;

        public LogMessage(LogLevel level, String message, boolean prefix) {
            this.level = level;
            this.message = message;
            this.prefix = prefix;
        }

        public String getMessage() {
            return this.message;
        }

        public LogLevel getLevel() {
            return this.level;
        }

        public boolean isPrefix() {
            return this.prefix;
        }
    }
}

