/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.util;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.util.MCDirection;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.util.BlockPos")
@Document(value="vanilla/api/util/BlockPos")
@ZenWrapper(wrappedClass="net.minecraft.util.math.BlockPos", conversionMethodFormat="%s.getInternal()", displayStringFormat="%s.getInternal.toString()")
public class MCBlockPos {
    private BlockPos internal;

    public MCBlockPos(BlockPos internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public MCBlockPos(int x, int y, int z) {
        this.internal = new BlockPos(x, y, z);
    }

    @ZenCodeType.Caster
    public long toLong() {
        return this.internal.func_218275_a();
    }

    @ZenCodeType.Method
    public MCBlockPos add(double x, double y, double z) {
        return x == 0.0 && y == 0.0 && z == 0.0 ? this : new MCBlockPos(new BlockPos((double)this.getX() + x, (double)this.getY() + y, (double)this.getZ() + z));
    }

    @ZenCodeType.Method
    public MCBlockPos add(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new MCBlockPos(new BlockPos(this.getX() + x, this.getY() + y, this.getZ() + z));
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.ADD)
    public MCBlockPos add(MCBlockPos pos) {
        return this.add(pos);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.SUB)
    public MCBlockPos subtract(MCBlockPos pos) {
        return this.add(-pos.getX(), -pos.getY(), -pos.getZ());
    }

    @ZenCodeType.Method
    public BlockPos up() {
        return this.internal.func_177984_a();
    }

    @ZenCodeType.Method
    public BlockPos up(int n) {
        return this.internal.func_177981_b(n);
    }

    @ZenCodeType.Method
    public BlockPos down() {
        return this.internal.func_177977_b();
    }

    public BlockPos down(int n) {
        return this.internal.func_177979_c(n);
    }

    @ZenCodeType.Method
    public BlockPos north() {
        return this.internal.func_177978_c();
    }

    @ZenCodeType.Method
    public BlockPos north(int n) {
        return this.internal.func_177964_d(n);
    }

    @ZenCodeType.Method
    public BlockPos south() {
        return this.internal.func_177968_d();
    }

    @ZenCodeType.Method
    public BlockPos south(int n) {
        return this.internal.func_177970_e(n);
    }

    @ZenCodeType.Method
    public BlockPos west() {
        return this.internal.func_177976_e();
    }

    @ZenCodeType.Method
    public BlockPos west(int n) {
        return this.internal.func_177985_f(n);
    }

    @ZenCodeType.Method
    public BlockPos east() {
        return this.internal.func_177974_f();
    }

    @ZenCodeType.Method
    public BlockPos east(int n) {
        return this.internal.func_177965_g(n);
    }

    @ZenCodeType.Method
    public MCBlockPos offset(MCDirection direction) {
        return this.offset(direction, 1);
    }

    @ZenCodeType.Method
    public MCBlockPos offset(MCDirection direction, int n) {
        return n == 0 ? this : new MCBlockPos(new BlockPos(this.getX() + direction.getXOffset() * n, this.getY() + direction.getYOffset() * n, this.getZ() + direction.getZOffset() * n));
    }

    @ZenCodeType.Method
    public MCBlockPos crossProduct(MCBlockPos pos) {
        return new MCBlockPos(this.getY() * pos.getZ() - this.getZ() * pos.getY(), this.getZ() * pos.getX() - this.getX() * pos.getZ(), this.getX() * pos.getY() - this.getY() * pos.getX());
    }

    @ZenCodeType.Getter(value="x")
    public int getX() {
        return this.internal.func_177958_n();
    }

    @ZenCodeType.Getter(value="y")
    public int getY() {
        return this.internal.func_177956_o();
    }

    @ZenCodeType.Getter(value="z")
    public int getZ() {
        return this.internal.func_177952_p();
    }

    @ZenCodeType.Method
    public boolean withinDistance(MCBlockPos pos, double distance) {
        return this.distanceSq(pos.getX(), pos.getY(), pos.getZ(), true) < distance * distance;
    }

    @ZenCodeType.Method
    public double distanceSq(MCBlockPos to) {
        return this.distanceSq(to, true);
    }

    @ZenCodeType.Method
    public double distanceSq(MCBlockPos to, boolean useCenter) {
        return this.distanceSq(to.getX(), to.getY(), to.getZ(), useCenter);
    }

    @ZenCodeType.Method
    public double distanceSq(double x, double y, double z, boolean useCenter) {
        return this.internal.func_218140_a(x, y, z, useCenter);
    }

    @ZenCodeType.Method
    public int manhattanDistance(MCBlockPos other) {
        return this.internal.func_218139_n((Vec3i)other.getInternal());
    }

    public BlockPos getInternal() {
        return this.internal;
    }
}

