/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zencode.java;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openzen.zencode.java.StorageTagType;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeStorageTag;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.LiteralSourceFile;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Module;
import org.openzen.zenscript.codemodel.ModuleSpace;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.PackageDefinitions;
import org.openzen.zenscript.codemodel.SemanticModule;
import org.openzen.zenscript.codemodel.annotations.AnnotationDefinition;
import org.openzen.zenscript.codemodel.annotations.DefinitionAnnotation;
import org.openzen.zenscript.codemodel.annotations.NativeDefinitionAnnotation;
import org.openzen.zenscript.codemodel.context.CompilingPackage;
import org.openzen.zenscript.codemodel.context.FileResolutionContext;
import org.openzen.zenscript.codemodel.context.ModuleTypeResolutionContext;
import org.openzen.zenscript.codemodel.definition.ClassDefinition;
import org.openzen.zenscript.codemodel.definition.EnumDefinition;
import org.openzen.zenscript.codemodel.definition.ExpansionDefinition;
import org.openzen.zenscript.codemodel.definition.InterfaceDefinition;
import org.openzen.zenscript.codemodel.definition.StructDefinition;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.expression.ConstantByteExpression;
import org.openzen.zenscript.codemodel.expression.ConstantDoubleExpression;
import org.openzen.zenscript.codemodel.expression.ConstantFloatExpression;
import org.openzen.zenscript.codemodel.expression.ConstantIntExpression;
import org.openzen.zenscript.codemodel.expression.ConstantLongExpression;
import org.openzen.zenscript.codemodel.expression.ConstantSByteExpression;
import org.openzen.zenscript.codemodel.expression.ConstantShortExpression;
import org.openzen.zenscript.codemodel.expression.ConstantStringExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUIntExpression;
import org.openzen.zenscript.codemodel.expression.ConstantULongExpression;
import org.openzen.zenscript.codemodel.expression.ConstantUShortExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionSymbol;
import org.openzen.zenscript.codemodel.expression.StaticGetterExpression;
import org.openzen.zenscript.codemodel.expression.StorageCastExpression;
import org.openzen.zenscript.codemodel.generic.ParameterTypeBound;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.member.CasterMember;
import org.openzen.zenscript.codemodel.member.ConstructorMember;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.FunctionalMember;
import org.openzen.zenscript.codemodel.member.GetterMember;
import org.openzen.zenscript.codemodel.member.ImplementationMember;
import org.openzen.zenscript.codemodel.member.MethodMember;
import org.openzen.zenscript.codemodel.member.OperatorMember;
import org.openzen.zenscript.codemodel.member.PropertyMember;
import org.openzen.zenscript.codemodel.member.SetterMember;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.partial.PartialStaticMemberGroupExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.scope.FileScope;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.ISymbol;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.StringTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.BuiltinID;
import org.openzen.zenscript.codemodel.type.member.TypeMembers;
import org.openzen.zenscript.codemodel.type.storage.AutoStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StaticStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageType;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaFunctionalInterfaceStorageTag;
import org.openzen.zenscript.javashared.JavaImplementation;
import org.openzen.zenscript.javashared.JavaMethod;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.type.IParsedType;
import stdlib.Strings;

public class JavaNativeModule {
    public final Module module;
    private final ZSPackage pkg;
    private final String basePackage;
    private final GlobalTypeRegistry registry;
    private final PackageDefinitions definitions = new PackageDefinitions();
    private final JavaCompiledModule compiled;
    private final Map<Class<?>, HighLevelDefinition> definitionByClass = new HashMap();
    private final Map<Class<?>, TypeID> typeByClass = new HashMap();
    private final Map<Class<?>, TypeID> unsignedByClass = new HashMap();
    private final TypeVariableContext context = new TypeVariableContext();
    public final Map<String, ISymbol> globals = new HashMap<String, ISymbol>();
    private BracketExpressionParser bep;

    public JavaNativeModule(ZSPackage pkg, String name, String basePackage, GlobalTypeRegistry registry, JavaNativeModule[] dependencies) {
        this.pkg = pkg;
        this.basePackage = basePackage;
        this.module = new Module(name);
        this.registry = registry;
        for (JavaNativeModule dependency : dependencies) {
            this.definitionByClass.putAll(dependency.definitionByClass);
            this.context.typeVariables.putAll(dependency.context.typeVariables);
        }
        this.compiled = new JavaCompiledModule(this.module, FunctionParameter.NONE);
        this.typeByClass.put(Void.TYPE, BasicTypeID.VOID);
        this.typeByClass.put(Boolean.TYPE, BasicTypeID.BOOL);
        this.typeByClass.put(Byte.TYPE, BasicTypeID.SBYTE);
        this.typeByClass.put(Short.TYPE, BasicTypeID.SHORT);
        this.typeByClass.put(Integer.TYPE, BasicTypeID.INT);
        this.typeByClass.put(Long.TYPE, BasicTypeID.LONG);
        this.typeByClass.put(Float.TYPE, BasicTypeID.FLOAT);
        this.typeByClass.put(Double.TYPE, BasicTypeID.DOUBLE);
        this.typeByClass.put(String.class, StringTypeID.INSTANCE);
        this.typeByClass.put(Boolean.class, registry.getOptional(BasicTypeID.BOOL));
        this.typeByClass.put(Byte.class, registry.getOptional(BasicTypeID.BYTE));
        this.typeByClass.put(Short.class, registry.getOptional(BasicTypeID.SHORT));
        this.typeByClass.put(Integer.class, registry.getOptional(BasicTypeID.INT));
        this.typeByClass.put(Long.class, registry.getOptional(BasicTypeID.LONG));
        this.typeByClass.put(Float.class, registry.getOptional(BasicTypeID.FLOAT));
        this.typeByClass.put(Double.class, registry.getOptional(BasicTypeID.DOUBLE));
        this.unsignedByClass.put(Byte.TYPE, BasicTypeID.BYTE);
        this.unsignedByClass.put(Short.TYPE, BasicTypeID.USHORT);
        this.unsignedByClass.put(Integer.TYPE, BasicTypeID.UINT);
        this.unsignedByClass.put(Long.TYPE, BasicTypeID.ULONG);
        this.unsignedByClass.put(Byte.class, registry.getOptional(BasicTypeID.BYTE));
        this.unsignedByClass.put(Short.class, registry.getOptional(BasicTypeID.SHORT));
        this.unsignedByClass.put(Integer.class, registry.getOptional(BasicTypeID.INT));
        this.unsignedByClass.put(Long.class, registry.getOptional(BasicTypeID.LONG));
    }

    public SemanticModule toSemantic(ModuleSpace space) {
        return new SemanticModule(this.module, SemanticModule.NONE, FunctionParameter.NONE, SemanticModule.State.NORMALIZED, space.rootPackage, this.pkg, this.definitions, Collections.emptyList(), space.registry, space.collectExpansions(), space.getAnnotations(), space.getStorageTypes());
    }

    public JavaCompiledModule getCompiled() {
        return this.compiled;
    }

    public HighLevelDefinition addClass(Class<?> cls) {
        if (this.definitionByClass.containsKey(cls)) {
            return this.definitionByClass.get(cls);
        }
        return this.convertClass(cls);
    }

    public void addGlobals(Class<?> cls) {
        ZenCodeGlobals.Global global;
        ClassDefinition definition = new ClassDefinition(CodePosition.NATIVE, this.module, this.pkg, "__globals__", 1);
        JavaClass jcls = JavaClass.fromInternalName(JavaNativeModule.getInternalName(cls), JavaClass.Kind.CLASS);
        this.compiled.setClassInfo(definition, jcls);
        StoredType thisType = this.registry.getForMyDefinition(definition).stored();
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ZenCodeGlobals.Global.class) || !JavaNativeModule.isStatic(field.getModifiers())) continue;
            global = field.getAnnotation(ZenCodeGlobals.Global.class);
            StoredType type = this.loadStoredType(this.context, field.getAnnotatedType());
            String name = global.value().isEmpty() ? field.getName() : global.value();
            FieldMember fieldMember = new FieldMember(CodePosition.NATIVE, (HighLevelDefinition)definition, 129, name, thisType, type, this.registry, 1, 0, null);
            definition.addMember(fieldMember);
            JavaField javaField = new JavaField(jcls, field.getName(), JavaNativeModule.getDescriptor(field.getType()));
            this.compiled.setFieldInfo(fieldMember, javaField);
            this.compiled.setFieldInfo(fieldMember.autoGetter, javaField);
            this.globals.put(name, new ExpressionSymbol((position, scope) -> new StaticGetterExpression(CodePosition.BUILTIN, fieldMember.autoGetter.ref(thisType, GenericMapper.EMPTY))));
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(ZenCodeGlobals.Global.class) || !JavaNativeModule.isStatic(((Method)accessibleObject).getModifiers())) continue;
            global = ((Method)accessibleObject).getAnnotation(ZenCodeGlobals.Global.class);
            String name = global.value().isEmpty() ? ((Method)accessibleObject).getName() : global.value();
            MethodMember methodMember = new MethodMember(CodePosition.NATIVE, definition, 129, name, this.getHeader(this.context, (Method)accessibleObject), null);
            definition.addMember(methodMember);
            boolean isGenericResult = methodMember.header.getReturnType().isGeneric();
            this.compiled.setMethodInfo(methodMember, new JavaMethod(jcls, JavaMethod.Kind.STATIC, ((Method)accessibleObject).getName(), false, JavaNativeModule.getMethodDescriptor((Method)accessibleObject), ((Method)accessibleObject).getModifiers(), isGenericResult));
            this.globals.put(name, new ExpressionSymbol((position, scope) -> {
                TypeMembers members = scope.getTypeMembers(thisType);
                return new PartialStaticMemberGroupExpression((CodePosition)position, (TypeScope)scope, thisType.type, members.getGroup(name), StoredType.NONE);
            }));
        }
    }

    public FunctionalMemberRef loadStaticMethod(Method method) {
        if (!JavaNativeModule.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method \"" + method.toString() + "\" is not static");
        }
        HighLevelDefinition definition = this.addClass(method.getDeclaringClass());
        JavaClass jcls = JavaClass.fromInternalName(JavaNativeModule.getInternalName(method.getDeclaringClass()), JavaClass.Kind.CLASS);
        MethodMember methodMember = new MethodMember(CodePosition.NATIVE, definition, 129, method.getName(), this.getHeader(this.context, method), null);
        definition.addMember(methodMember);
        boolean isGenericResult = methodMember.header.getReturnType().isGeneric();
        this.compiled.setMethodInfo(methodMember, new JavaMethod(jcls, JavaMethod.Kind.STATIC, method.getName(), false, JavaNativeModule.getMethodDescriptor(method), method.getModifiers(), isGenericResult));
        return methodMember.ref(this.registry.getForDefinition(definition, new StoredType[0]).stored());
    }

    private boolean isInBasePackage(String className) {
        return className.startsWith(this.basePackage + ".") || className.startsWith("java.lang.") || className.startsWith("java.util.");
    }

    private ZSPackage getPackage(String className) {
        if (this.basePackage == null || this.basePackage.isEmpty()) {
            return this.pkg;
        }
        if (!className.contains(".") || className.startsWith("java.lang")) {
            return this.pkg;
        }
        if (className.startsWith(".")) {
            className = className.substring(1);
        } else if (className.startsWith(this.basePackage + ".")) {
            className = className.substring(this.basePackage.length() + 1);
        } else {
            throw new IllegalArgumentException("Invalid class name: \"" + className + "\" not in the given base package: \"" + this.basePackage + "\"");
        }
        String[] classNameParts = Strings.split(className, '.');
        ZSPackage classPkg = this.pkg;
        for (int i = 0; i < classNameParts.length - 1; ++i) {
            classPkg = classPkg.getOrCreatePackage(classNameParts[i]);
        }
        return classPkg;
    }

    private <T> HighLevelDefinition checkRegistry(Class<T> cls) {
        String name = cls.getCanonicalName();
        if (!name.startsWith("java.lang.") && !name.startsWith("java.util.")) {
            return null;
        }
        name = name.substring("java.lang.".length());
        for (DefinitionTypeID definition : this.registry.getDefinitions()) {
            HighLevelDefinition highLevelDefinition = definition.definition;
            for (DefinitionAnnotation annotation : highLevelDefinition.annotations) {
                String identifier;
                if (!(annotation instanceof NativeDefinitionAnnotation) || !(identifier = ((NativeDefinitionAnnotation)annotation).getIdentifier()).equals(name) && !identifier.equals("stdlib::" + name)) continue;
                return highLevelDefinition;
            }
        }
        return null;
    }

    private <T> HighLevelDefinition convertClass(Class<T> cls) {
        FunctionalMember member;
        PropertyMember member2;
        TypeParameter parameter;
        TypeVariable<Class<T>> typeVariable;
        int i;
        JavaClass javaClass;
        if ((cls.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("Class \" " + cls.getName() + "\" must be public");
        }
        if (cls.isAnnotationPresent(ZenCodeType.Expansion.class)) {
            return this.convertExpansion(cls);
        }
        String className = cls.getName();
        boolean isStruct = cls.isAnnotationPresent(ZenCodeType.Struct.class);
        HighLevelDefinition definition = this.checkRegistry(cls);
        boolean foundRegistry = definition != null;
        String internalName = JavaNativeModule.getInternalName(cls);
        if (foundRegistry) {
            javaClass = JavaClass.fromInternalName(internalName, definition.isInterface() ? JavaClass.Kind.INTERFACE : JavaClass.Kind.CLASS);
        } else {
            ZSPackage classPkg;
            ZenCodeType.Name nameAnnotation = cls.getDeclaredAnnotation(ZenCodeType.Name.class);
            String string = className = className.contains(".") ? className.substring(className.lastIndexOf(46) + 1) : className;
            if (nameAnnotation == null) {
                classPkg = this.getPackage(className);
            } else {
                String specifiedName = nameAnnotation.value();
                if (specifiedName.startsWith(".")) {
                    classPkg = this.getPackage(specifiedName);
                    className = specifiedName.substring(specifiedName.lastIndexOf(46) + 1);
                } else if (specifiedName.indexOf(46) >= 0) {
                    if (!specifiedName.startsWith(this.pkg.fullName)) {
                        throw new IllegalArgumentException("Specified @Name as \"" + specifiedName + "\" for class: \"" + cls.toString() + "\" but it's not in the module root package: \"" + this.pkg.fullName + "\"");
                    }
                    classPkg = this.getPackage(this.basePackage + specifiedName.substring(this.pkg.fullName.length()));
                    className = specifiedName.substring(specifiedName.lastIndexOf(46) + 1);
                } else {
                    classPkg = this.getPackage(specifiedName);
                    className = nameAnnotation.value();
                }
            }
            if (cls.isInterface()) {
                definition = new InterfaceDefinition(CodePosition.NATIVE, this.module, classPkg, className, 1, null);
                javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.INTERFACE);
            } else if (cls.isEnum()) {
                definition = new EnumDefinition(CodePosition.NATIVE, this.module, classPkg, className, 1, null);
                javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.ENUM);
            } else if (isStruct) {
                definition = new StructDefinition(CodePosition.NATIVE, this.module, classPkg, className, 1, null);
                javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.CLASS);
            } else {
                definition = new ClassDefinition(CodePosition.NATIVE, this.module, classPkg, className, 1);
                javaClass = JavaClass.fromInternalName(internalName, JavaClass.Kind.CLASS);
            }
        }
        this.definitionByClass.put(cls, definition);
        if (!this.shouldLoadClass(cls)) {
            return definition;
        }
        TypeVariable<Class<T>>[] javaTypeParameters = cls.getTypeParameters();
        TypeParameter[] typeParameters = new TypeParameter[cls.getTypeParameters().length];
        definition.typeParameters = typeParameters;
        for (i = 0; i < javaTypeParameters.length; ++i) {
            typeVariable = javaTypeParameters[i];
            typeParameters[i] = parameter = new TypeParameter(CodePosition.NATIVE, typeVariable.getName());
            this.context.put(typeVariable, parameter);
        }
        for (i = 0; i < javaTypeParameters.length; ++i) {
            typeVariable = javaTypeParameters[i];
            parameter = typeParameters[i];
            for (AnnotatedType bound : typeVariable.getAnnotatedBounds()) {
                TypeID type = this.loadType((TypeVariableContext)this.context, (AnnotatedType)bound).type;
                parameter.addBound(new ParameterTypeBound(CodePosition.NATIVE, type));
            }
            typeParameters[i] = parameter;
        }
        if (!foundRegistry && definition instanceof ClassDefinition && cls.getAnnotatedSuperclass() != null && this.shouldLoadType(cls.getAnnotatedSuperclass().getType())) {
            definition.setSuperType(this.loadType((TypeVariableContext)this.context, (AnnotatedType)cls.getAnnotatedSuperclass()).type);
        }
        if (!foundRegistry && definition.getSuperType() == null && cls != Object.class) {
            definition.setSuperType(this.loadType((TypeVariableContext)this.context, Object.class, (boolean)false, (boolean)false).type);
        }
        for (AnnotatedType iface : cls.getAnnotatedInterfaces()) {
            if (!this.shouldLoadType(iface.getType())) continue;
            TypeID type = this.loadType((TypeVariableContext)this.context, (AnnotatedType)iface).type;
            ImplementationMember member3 = new ImplementationMember(CodePosition.NATIVE, definition, 1, type);
            definition.members.add(member3);
            this.compiled.setImplementationInfo(member3, new JavaImplementation(true, javaClass));
        }
        this.compiled.setClassInfo(definition, javaClass);
        StoredType thisType = new StoredType(this.registry.getForMyDefinition(definition), AutoStorageTag.INSTANCE);
        for (Field field : cls.getDeclaredFields()) {
            ZenCodeType.Field annotation = field.getAnnotation(ZenCodeType.Field.class);
            if (annotation == null || !JavaNativeModule.isPublic(field.getModifiers())) continue;
            String fieldName = annotation.value().isEmpty() ? field.getName() : annotation.value();
            StoredType fieldType = this.loadStoredType(this.context, field.getAnnotatedType());
            member2 = new FieldMember(CodePosition.NATIVE, definition, this.getMethodModifiers(field), fieldName, thisType, fieldType, this.registry, 0, 0, null);
            definition.addMember(member2);
            this.compiled.setFieldInfo(member2, new JavaField(javaClass, field.getName(), JavaNativeModule.getDescriptor(field.getType())));
        }
        boolean hasConstructor = false;
        for (Constructor<?> constructor : cls.getConstructors()) {
            ZenCodeType.Constructor constructorAnnotation = constructor.getAnnotation(ZenCodeType.Constructor.class);
            if (constructorAnnotation == null) continue;
            member = this.asConstructor(this.context, definition, constructor);
            definition.addMember(member);
            this.compiled.setMethodInfo(member, JavaNativeModule.getMethod(javaClass, constructor));
            hasConstructor = true;
        }
        if (!hasConstructor && !foundRegistry) {
            ConstructorMember member4 = new ConstructorMember(CodePosition.BUILTIN, definition, 4, new FunctionHeader(BasicTypeID.VOID), BuiltinID.CLASS_DEFAULT_CONSTRUCTOR);
            definition.addMember(member4);
        }
        for (Method method : cls.getDeclaredMethods()) {
            ZenCodeType.Caster caster;
            ZenCodeType.Operator operator;
            ZenCodeType.Setter setter;
            ZenCodeType.Method methodAnnotation = method.getAnnotation(ZenCodeType.Method.class);
            if (methodAnnotation != null) {
                block35: {
                    try {
                        if (!cls.getDeclaredMethod(method.getName(), method.getParameterTypes()).equals(method)) {
                        }
                        break block35;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                member = this.asMethod(this.context, definition, method, methodAnnotation);
                definition.addMember(member);
                this.compiled.setMethodInfo(member, JavaNativeModule.getMethod(javaClass, method, ((MethodMember)member).header.getReturnType()));
                continue;
            }
            ZenCodeType.Getter getter = method.getAnnotation(ZenCodeType.Getter.class);
            if (getter != null) {
                member2 = this.asGetter(this.context, definition, method, getter);
                definition.addMember(member2);
                this.compiled.setMethodInfo(member2, JavaNativeModule.getMethod(javaClass, method, member2.getType()));
            }
            if ((setter = method.getAnnotation(ZenCodeType.Setter.class)) != null) {
                SetterMember member5 = this.asSetter(this.context, definition, method, setter);
                definition.addMember(member5);
                this.compiled.setMethodInfo(member5, JavaNativeModule.getMethod(javaClass, method, BasicTypeID.VOID.stored));
            }
            if ((operator = method.getAnnotation(ZenCodeType.Operator.class)) != null) {
                OperatorMember member6 = this.asOperator(this.context, definition, method, operator);
                definition.addMember(member6);
                this.compiled.setMethodInfo(member6, JavaNativeModule.getMethod(javaClass, method, member6.header.getReturnType()));
            }
            if ((caster = method.getAnnotation(ZenCodeType.Caster.class)) == null) continue;
            CasterMember member7 = this.asCaster(this.context, definition, method, caster);
            definition.addMember(member7);
            this.compiled.setMethodInfo(member7, JavaNativeModule.getMethod(javaClass, method, member7.toType));
        }
        return definition;
    }

    private <T> ExpansionDefinition convertExpansion(Class<T> cls) {
        if (!cls.isAnnotationPresent(ZenCodeType.Expansion.class)) {
            throw new IllegalArgumentException("Cannot convert class " + cls + " as it does not have an Expansion annotation");
        }
        String expandedName = cls.getAnnotation(ZenCodeType.Expansion.class).value();
        TypeID expandedType = this.getTypeFromName(expandedName);
        if (expandedType == null) {
            throw new IllegalArgumentException("Could not find definition for name " + expandedName);
        }
        ExpansionDefinition expansion = new ExpansionDefinition(CodePosition.NATIVE, this.module, this.pkg, 1, null);
        JavaClass javaClass = JavaClass.fromInternalName(JavaNativeModule.getInternalName(cls), JavaClass.Kind.CLASS);
        expansion.target = expandedType.stored();
        this.definitionByClass.put(cls, expansion);
        boolean addExpansion = false;
        for (Method method : cls.getDeclaredMethods()) {
            ZenCodeType.Caster casterAnnotation;
            if (!Modifier.isStatic(method.getModifiers()) || method.getParameterCount() < 1) continue;
            Class<?> classFromType = this.getClassFromType(expandedType);
            if (classFromType == null) {
                System.err.println("Could not get class for type " + expandedType + " attempting to do stuff anyways");
            } else if (!method.getParameterTypes()[0].isAssignableFrom(classFromType)) {
                throw new IllegalArgumentException("Cannot add extension method " + method + " as its first parameter does not match the extended type.");
            }
            ZenCodeType.Method methodAnnotation = method.getAnnotation(ZenCodeType.Method.class);
            if (methodAnnotation != null) {
                String name = !methodAnnotation.value().isEmpty() ? methodAnnotation.value() : method.getName();
                Parameter[] parameters = this.getExpansionParameters(method);
                FunctionHeader header = this.getHeader(this.context, method.getAnnotatedReturnType(), parameters, method.getTypeParameters(), method.getAnnotatedExceptionTypes());
                MethodMember member = new MethodMember(CodePosition.NATIVE, expansion, this.getMethodModifiers(method) ^ 0x80, name, header, null);
                expansion.addMember(member);
                this.compiled.setMethodInfo(member, JavaMethod.getStatic(javaClass, name, JavaNativeModule.getMethodDescriptor(method), this.getMethodModifiers(method)));
                addExpansion = true;
            }
            if ((casterAnnotation = method.getAnnotation(ZenCodeType.Caster.class)) == null) continue;
            boolean implicit = casterAnnotation.implicit();
            int modifiers = this.getMethodModifiers(method) ^ 0x80;
            if (implicit) {
                modifiers |= 0x200;
            }
            StoredType toType = this.loadStoredType(this.context, method.getAnnotatedReturnType());
            CasterMember member = new CasterMember(CodePosition.NATIVE, (HighLevelDefinition)expansion, modifiers, toType, null);
            expansion.addMember(member);
            this.compiled.setMethodInfo(member, JavaNativeModule.getMethod(javaClass, method, member.toType));
            addExpansion = true;
        }
        if (addExpansion) {
            this.compiled.setExpansionClassInfo(expansion, javaClass);
            this.definitions.add(expansion);
        }
        return expansion;
    }

    private Class<?> getClassFromType(TypeID type) {
        if (type instanceof DefinitionTypeID) {
            DefinitionTypeID definitionType = (DefinitionTypeID)type;
            for (Map.Entry<Class<?>, HighLevelDefinition> ent : this.definitionByClass.entrySet()) {
                if (!ent.getValue().equals(definitionType.definition)) continue;
                return ent.getKey();
            }
        }
        for (Map.Entry<Class<?>, TypeID> ent : this.typeByClass.entrySet()) {
            if (!ent.getValue().equals(type)) continue;
            return ent.getKey();
        }
        for (Map.Entry<Class<?>, TypeID> ent : this.unsignedByClass.entrySet()) {
            if (!ent.getValue().equals(type)) continue;
            return ent.getKey();
        }
        return null;
    }

    private Parameter[] getExpansionParameters(Method method) {
        Parameter[] parameters = new Parameter[method.getParameterCount() - 1];
        System.arraycopy(method.getParameters(), 1, parameters, 0, method.getParameterCount() - 1);
        return parameters;
    }

    private TypeID getTypeFromName(String className) {
        for (TypeID value : this.typeByClass.values()) {
            if (!value.toString().equals(className)) continue;
            return value;
        }
        for (TypeID value : this.unsignedByClass.values()) {
            if (!value.toString().equals(className)) continue;
            return value;
        }
        try {
            ZSPackage zsPackage = this.getPackage(className);
            String[] split = className.split("\\.");
            String actualName = split[split.length - 1];
            for (HighLevelDefinition value : this.definitionByClass.values()) {
                if (!actualName.equals(value.name) || !value.pkg.equals(zsPackage)) continue;
                return this.registry.getForMyDefinition(value);
            }
        }
        catch (IllegalArgumentException zsPackage) {
            // empty catch block
        }
        CompilingPackage rootCompiling = new CompilingPackage(this.pkg.parent, this.module);
        ModuleTypeResolutionContext context = new ModuleTypeResolutionContext(this.registry, new AnnotationDefinition[0], StorageType.getStandard(), this.pkg.parent, rootCompiling, this.globals);
        try {
            ZSTokenParser tokens = ZSTokenParser.create(new LiteralSourceFile("type reading: " + className, className), this.bep, 4);
            return IParsedType.parse(tokens).compileUnstored(context);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean shouldLoadType(Type type) {
        if (type instanceof Class) {
            return this.definitionByClass.containsKey(type) || this.shouldLoadClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.shouldLoadType(((ParameterizedType)type).getRawType());
        }
        return false;
    }

    private String getClassName(Class<?> cls) {
        return cls.isAnnotationPresent(ZenCodeType.Name.class) ? cls.getAnnotation(ZenCodeType.Name.class).value() : cls.getName();
    }

    private boolean shouldLoadClass(Class<?> cls) {
        return this.isInBasePackage(this.getClassName(cls));
    }

    private boolean isGetterName(String name) {
        return name.startsWith("get") || name.startsWith("is") || name.startsWith("has");
    }

    private String translateGetterName(String name) {
        if (name.startsWith("get")) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return name;
    }

    private String translateSetterName(String name) {
        if (name.startsWith("set")) {
            return name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return name;
    }

    private ConstructorMember asConstructor(TypeVariableContext context, HighLevelDefinition definition, Constructor method) {
        FunctionHeader header = this.getHeader(context, method);
        return new ConstructorMember(CodePosition.NATIVE, definition, 1, header, null);
    }

    private MethodMember asMethod(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Method annotation) {
        String name = annotation != null && !annotation.value().isEmpty() ? annotation.value() : method.getName();
        FunctionHeader header = this.getHeader(context, method);
        return new MethodMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), name, header, null);
    }

    private OperatorMember asOperator(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Operator annotation) {
        FunctionHeader header = this.getHeader(context, method);
        if (JavaNativeModule.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("operator method \"" + method.toString() + "\"cannot be static");
        }
        return new OperatorMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), OperatorType.valueOf(annotation.value().toString()), header, null);
    }

    private GetterMember asGetter(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Getter annotation) {
        StoredType type = this.loadStoredType(context, method.getAnnotatedReturnType());
        String name = null;
        if (annotation != null && !annotation.value().isEmpty()) {
            name = annotation.value();
        }
        if (name == null) {
            name = this.translateGetterName(method.getName());
        }
        return new GetterMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), name, type, null);
    }

    private SetterMember asSetter(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Setter annotation) {
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("Illegal setter: \"" + method.toString() + "\"must have exactly 1 parameter");
        }
        StoredType type = this.loadStoredType(context, method.getAnnotatedParameterTypes()[0]);
        String name = null;
        if (annotation != null && !annotation.value().isEmpty()) {
            name = annotation.value();
        }
        if (name == null) {
            name = this.translateSetterName(method.getName());
        }
        return new SetterMember(CodePosition.NATIVE, definition, this.getMethodModifiers(method), name, type, null);
    }

    private CasterMember asCaster(TypeVariableContext context, HighLevelDefinition definition, Method method, ZenCodeType.Caster annotation) {
        boolean implicit = annotation != null && annotation.implicit();
        int modifiers = 1;
        if (implicit) {
            modifiers |= 0x200;
        }
        StoredType toType = this.loadStoredType(context, method.getAnnotatedReturnType());
        return new CasterMember(CodePosition.NATIVE, definition, modifiers, toType, null);
    }

    private FunctionHeader getHeader(TypeVariableContext context, Constructor constructor) {
        return this.getHeader(context, null, constructor.getParameters(), constructor.getTypeParameters(), constructor.getAnnotatedExceptionTypes());
    }

    private FunctionHeader getHeader(TypeVariableContext context, Method method) {
        return this.getHeader(context, method.getAnnotatedReturnType(), method.getParameters(), method.getTypeParameters(), method.getAnnotatedExceptionTypes());
    }

    protected Expression getDefaultValue(Parameter parameter, StoredType type) {
        if (parameter.isAnnotationPresent(ZenCodeType.Optional.class)) {
            String s = parameter.getAnnotation(ZenCodeType.Optional.class).value();
            try {
                String filename = "internal: " + parameter.getDeclaringExecutable().getName();
                CompilingPackage rootCompiling = new CompilingPackage(this.pkg, this.module);
                ModuleTypeResolutionContext context = new ModuleTypeResolutionContext(this.registry, new AnnotationDefinition[0], StorageType.getStandard(), this.pkg, rootCompiling, this.globals);
                FileResolutionContext fContext = new FileResolutionContext(context, this.pkg, rootCompiling);
                FileScope fileScope = new FileScope(fContext, Collections.emptyList(), this.globals, member -> {});
                ZSTokenParser tokens = ZSTokenParser.create(new LiteralSourceFile(filename, s), this.bep, 4);
                return ParsedExpression.parse(tokens).compile(new ExpressionScope(fileScope)).eval().castExplicit(CodePosition.GENERATED, fileScope, type, type.isOptional());
            }
            catch (IOException | CompileException | ParseException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalInt.class)) {
            ZenCodeType.OptionalInt annotation = parameter.getAnnotation(ZenCodeType.OptionalInt.class);
            if (type.type == BasicTypeID.BYTE) {
                return new ConstantByteExpression(CodePosition.NATIVE, annotation.value());
            }
            if (type.type == BasicTypeID.SBYTE) {
                return new ConstantSByteExpression(CodePosition.NATIVE, (byte)annotation.value());
            }
            if (type.type == BasicTypeID.SHORT) {
                return new ConstantShortExpression(CodePosition.NATIVE, (short)annotation.value());
            }
            if (type.type == BasicTypeID.USHORT) {
                return new ConstantUShortExpression(CodePosition.NATIVE, annotation.value());
            }
            if (type.type == BasicTypeID.INT) {
                return new ConstantIntExpression(CodePosition.NATIVE, annotation.value());
            }
            if (type.type == BasicTypeID.UINT) {
                return new ConstantUIntExpression(CodePosition.NATIVE, annotation.value());
            }
            throw new IllegalArgumentException("Cannot use int default values for " + type.toString());
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalLong.class)) {
            ZenCodeType.OptionalLong annotation = parameter.getAnnotation(ZenCodeType.OptionalLong.class);
            if (type.type == BasicTypeID.LONG) {
                return new ConstantLongExpression(CodePosition.NATIVE, annotation.value());
            }
            if (type.type == BasicTypeID.ULONG) {
                return new ConstantULongExpression(CodePosition.NATIVE, annotation.value());
            }
            throw new IllegalArgumentException("Cannot use long default values for " + type.toString());
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalFloat.class)) {
            ZenCodeType.OptionalFloat annotation = parameter.getAnnotation(ZenCodeType.OptionalFloat.class);
            if (type.type == BasicTypeID.FLOAT) {
                return new ConstantFloatExpression(CodePosition.NATIVE, annotation.value());
            }
            throw new IllegalArgumentException("Cannot use float default values for " + type.toString());
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalDouble.class)) {
            ZenCodeType.OptionalDouble annotation = parameter.getAnnotation(ZenCodeType.OptionalDouble.class);
            if (type.type == BasicTypeID.DOUBLE) {
                return new ConstantDoubleExpression(CodePosition.NATIVE, annotation.value());
            }
            throw new IllegalArgumentException("Cannot use double default values for " + type.toString());
        }
        if (parameter.isAnnotationPresent(ZenCodeType.OptionalString.class)) {
            ZenCodeType.OptionalString annotation = parameter.getAnnotation(ZenCodeType.OptionalString.class);
            if (type.type == StringTypeID.INSTANCE) {
                Expression result = new ConstantStringExpression(CodePosition.NATIVE, annotation.value());
                if (type.getActualStorage() != StaticStorageTag.INSTANCE) {
                    result = new StorageCastExpression(CodePosition.NATIVE, result, type);
                }
                return result;
            }
            throw new IllegalArgumentException("Cannot use string default values for " + type.toString());
        }
        return null;
    }

    private FunctionHeader getHeader(TypeVariableContext context, AnnotatedType javaReturnType, Parameter[] javaParameters, TypeVariable<Method>[] javaTypeParameters, AnnotatedType[] exceptionTypes) {
        Object parameter;
        int i;
        TypeParameter[] typeParameters = new TypeParameter[javaTypeParameters.length];
        for (i = 0; i < javaTypeParameters.length; ++i) {
            TypeVariable<Method> typeVariable = javaTypeParameters[i];
            parameter = new TypeParameter(CodePosition.NATIVE, typeVariable.getName());
            typeParameters[i] = parameter;
            context.put(typeVariable, (TypeParameter)parameter);
        }
        for (i = 0; i < javaTypeParameters.length; ++i) {
            TypeVariable<Method> javaTypeParameter = javaTypeParameters[i];
            for (AnnotatedType bound : javaTypeParameter.getAnnotatedBounds()) {
                typeParameters[i].addBound(new ParameterTypeBound(CodePosition.NATIVE, this.loadType((TypeVariableContext)context, (AnnotatedType)bound).type));
            }
        }
        FunctionParameter[] parameters = new FunctionParameter[javaParameters.length];
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            parameter = javaParameters[i2];
            StoredType type = this.loadStoredType(context, (Parameter)parameter);
            Expression defaultValue = this.getDefaultValue((Parameter)parameter, type);
            parameters[i2] = new FunctionParameter(type, ((Parameter)parameter).getName(), defaultValue, ((Parameter)parameter).isVarArgs());
        }
        if (exceptionTypes.length > 1) {
            throw new IllegalArgumentException("A method can only throw a single exception type!");
        }
        StoredType returnType = javaReturnType == null ? BasicTypeID.VOID.stored : this.loadStoredType(context, javaReturnType);
        StoredType thrownType = exceptionTypes.length == 0 ? null : this.loadStoredType(context, exceptionTypes[0]);
        return new FunctionHeader(typeParameters, returnType, thrownType, AutoStorageTag.INSTANCE, parameters);
    }

    private StoredType loadStoredType(TypeVariableContext context, AnnotatedType annotatedType) {
        return this.loadType(context, annotatedType);
    }

    private StoredType loadStoredType(TypeVariableContext context, Parameter parameter) {
        StoredType type = this.loadStoredType(context, parameter.getAnnotatedType());
        if (parameter.isAnnotationPresent(ZenCodeType.Optional.class) && !type.isOptional()) {
            return new StoredType(this.registry.getOptional(type.type), type.getSpecifiedStorage());
        }
        return type;
    }

    private StoredType loadType(TypeVariableContext context, AnnotatedType annotatedType) {
        if (annotatedType.isAnnotationPresent(ZenCodeType.USize.class)) {
            return BasicTypeID.USIZE.stored;
        }
        if (annotatedType.isAnnotationPresent(ZenCodeType.NullableUSize.class)) {
            return this.registry.getOptional(BasicTypeID.USIZE).stored();
        }
        boolean nullable = annotatedType.isAnnotationPresent(ZenCodeType.Nullable.class);
        boolean unsigned = annotatedType.isAnnotationPresent(ZenCodeType.Unsigned.class);
        return this.loadType(context, annotatedType, nullable, unsigned);
    }

    private StoredType loadType(TypeVariableContext context, AnnotatedElement type, boolean nullable, boolean unsigned) {
        StoredType result = this.loadType(context, type, unsigned);
        if (nullable) {
            result = new StoredType(this.registry.getOptional(result.type), result.getSpecifiedStorage());
        }
        return result;
    }

    private StoredType loadType(TypeVariableContext context, AnnotatedElement type, boolean unsigned) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (unsigned) {
                if (this.unsignedByClass.containsKey(classType)) {
                    return this.unsignedByClass.get(classType).stored();
                }
                throw new IllegalArgumentException("This class cannot be used as unsigned: " + classType);
            }
            if (classType.isArray()) {
                return this.registry.getArray(this.loadType(context, classType.getComponentType(), false, false), 1).stored();
            }
            if (classType.isAnnotationPresent(FunctionalInterface.class)) {
                return this.loadFunctionalInterface(context, classType, new AnnotatedElement[0]);
            }
            if (this.typeByClass.containsKey(classType)) {
                return this.typeByClass.get(classType).stored();
            }
            HighLevelDefinition definition = this.addClass(classType);
            ArrayList<StoredType> s = new ArrayList<StoredType>();
            for (TypeVariable typeParameter : classType.getTypeParameters()) {
                s.add(this.registry.getGeneric(context.get(typeParameter)).stored());
            }
            return this.registry.getForDefinition(definition, s.toArray(StoredType.NONE)).stored();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)((Object)type);
            Class rawType = (Class)parameterizedType.getRawType();
            if (rawType.isAnnotationPresent(FunctionalInterface.class)) {
                return this.loadFunctionalInterface(context, rawType, (AnnotatedElement[])parameterizedType.getActualTypeArguments());
            }
            Type[] parameters = parameterizedType.getActualTypeArguments();
            StoredType[] codeParameters = new StoredType[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                codeParameters[i] = this.loadType(context, (AnnotatedElement)((Object)parameters[i]), false, false);
            }
            if (rawType == Map.class) {
                return this.registry.getAssociative(codeParameters[0], codeParameters[1]).stored();
            }
            HighLevelDefinition definition = this.addClass(rawType);
            return this.registry.getForDefinition(definition, codeParameters).stored();
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            return this.registry.getGeneric(context.get(variable)).stored();
        }
        if (type instanceof AnnotatedType) {
            StoredType storedType;
            if (type instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
                Type rawType = ((ParameterizedType)parameterizedType.getType()).getRawType();
                AnnotatedType[] actualTypeArguments = parameterizedType.getAnnotatedActualTypeArguments();
                StoredType[] codeParameters = new StoredType[actualTypeArguments.length];
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    codeParameters[i] = this.loadType(context, actualTypeArguments[i], false, false);
                }
                if (rawType == Map.class) {
                    storedType = this.registry.getAssociative(codeParameters[0], codeParameters[1]).stored();
                } else if (rawType instanceof Class) {
                    HashMap<TypeParameter, StoredType> map = new HashMap<TypeParameter, StoredType>();
                    TypeVariable<Class<T>>[] typeParameters = ((Class)rawType).getTypeParameters();
                    StoredType loadType = this.loadType(context, (AnnotatedElement)((Object)rawType), unsigned);
                    for (int i = 0; i < typeParameters.length; ++i) {
                        TypeParameter typeParameter = context.get(typeParameters[i]);
                        map.put(typeParameter, codeParameters[i]);
                    }
                    storedType = loadType.instance(new GenericMapper(CodePosition.NATIVE, this.registry, map));
                } else {
                    storedType = this.loadType(context, (AnnotatedElement)((Object)rawType), unsigned);
                }
            } else {
                storedType = ((AnnotatedType)type).getType() instanceof WildcardType ? BasicTypeID.UNDETERMINED.stored() : this.loadType(context, (AnnotatedElement)((Object)((AnnotatedType)type).getType()), unsigned);
            }
            if (type.isAnnotationPresent(ZenCodeStorageTag.class) && type.getAnnotation(ZenCodeStorageTag.class).value() == StorageTagType.STATIC) {
                return storedType.type.stored(StorageTag.union(CodePosition.BUILTIN, storedType.getSpecifiedStorage(), StaticStorageTag.INSTANCE));
            }
            return storedType;
        }
        throw new IllegalArgumentException("Could not analyze type: " + type);
    }

    private StoredType loadFunctionalInterface(TypeVariableContext loadContext, Class<?> cls, AnnotatedElement[] parameters) {
        Method functionalInterfaceMethod = this.getFunctionalInterfaceMethod(cls);
        TypeVariableContext context = this.convertTypeParameters(cls);
        FunctionHeader header = this.getHeader(context, functionalInterfaceMethod);
        HashMap<TypeParameter, StoredType> mapping = new HashMap<TypeParameter, StoredType>();
        TypeVariable<Class<?>>[] javaParameters = cls.getTypeParameters();
        for (int i = 0; i < parameters.length; ++i) {
            mapping.put(context.get(javaParameters[i]), this.loadType(loadContext, parameters[i], false, false));
        }
        JavaMethod method = new JavaMethod(JavaClass.fromInternalName(JavaNativeModule.getInternalName(cls), JavaClass.Kind.INTERFACE), JavaMethod.Kind.INTERFACE, functionalInterfaceMethod.getName(), false, JavaNativeModule.getMethodDescriptor(functionalInterfaceMethod), 1025, header.getReturnType().type.isGeneric());
        JavaFunctionalInterfaceStorageTag tag = new JavaFunctionalInterfaceStorageTag(functionalInterfaceMethod, method);
        return this.registry.getFunction(header).stored(tag);
    }

    private <T> TypeVariableContext convertTypeParameters(Class<T> cls) {
        int i;
        TypeVariable<Class<T>>[] javaTypeParameters = cls.getTypeParameters();
        TypeParameter[] typeParameters = new TypeParameter[cls.getTypeParameters().length];
        for (i = 0; i < javaTypeParameters.length; ++i) {
            TypeParameter parameter;
            TypeVariable<Class<T>> typeVariable = javaTypeParameters[i];
            typeParameters[i] = parameter = new TypeParameter(CodePosition.NATIVE, typeVariable.getName());
            this.context.put(typeVariable, parameter);
        }
        for (i = 0; i < javaTypeParameters.length; ++i) {
            for (AnnotatedType bound : javaTypeParameters[i].getAnnotatedBounds()) {
                TypeID type = this.loadType((TypeVariableContext)this.context, (AnnotatedType)bound).type;
                typeParameters[i].addBound(new ParameterTypeBound(CodePosition.NATIVE, type));
            }
        }
        return this.context;
    }

    private Method getFunctionalInterfaceMethod(Class<?> functionalInterface) {
        for (Method method : functionalInterface.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isAbstract(method.getModifiers()) || method.isDefault()) continue;
            return method;
        }
        return null;
    }

    private int getMethodModifiers(Member method) {
        int result = 1;
        if (JavaNativeModule.isStatic(method.getModifiers())) {
            result |= 0x80;
        }
        if (JavaNativeModule.isFinal(method.getModifiers())) {
            result |= 0x10;
        }
        return result;
    }

    private static boolean isPublic(int modifiers) {
        return (modifiers & 1) > 0;
    }

    private static boolean isStatic(int modifiers) {
        return (modifiers & 8) > 0;
    }

    private static boolean isFinal(int modifiers) {
        return (modifiers & 0x10) > 0;
    }

    private static String getInternalName(Class<?> cls) {
        return org.objectweb.asm.Type.getInternalName(cls);
    }

    private static String getDescriptor(Class<?> cls) {
        return org.objectweb.asm.Type.getDescriptor(cls);
    }

    private static String getMethodDescriptor(Constructor constructor) {
        return org.objectweb.asm.Type.getConstructorDescriptor((Constructor)constructor);
    }

    private static String getMethodDescriptor(Method method) {
        return org.objectweb.asm.Type.getMethodDescriptor((Method)method);
    }

    private static JavaMethod getMethod(JavaClass cls, Constructor constructor) {
        return new JavaMethod(cls, JavaMethod.Kind.CONSTRUCTOR, "<init>", false, JavaNativeModule.getMethodDescriptor(constructor), constructor.getModifiers(), false);
    }

    private static JavaMethod getMethod(JavaClass cls, Method method, StoredType result) {
        JavaMethod.Kind kind = method.getName().equals("<init>") ? JavaMethod.Kind.CONSTRUCTOR : (method.getName().equals("<clinit>") ? JavaMethod.Kind.STATICINIT : (JavaNativeModule.isStatic(method.getModifiers()) ? JavaMethod.Kind.STATIC : JavaMethod.Kind.INSTANCE));
        return new JavaMethod(cls, kind, method.getName(), false, JavaNativeModule.getMethodDescriptor(method), method.getModifiers(), result.isGeneric());
    }

    public void registerBEP(BracketExpressionParser bep) {
        this.bep = bep;
    }

    private static class TypeVariableContext {
        private final Map<TypeVariable, TypeParameter> typeVariables = new HashMap<TypeVariable, TypeParameter>();

        private TypeVariableContext() {
        }

        public void put(TypeVariable variable, TypeParameter parameter) {
            this.typeVariables.put(variable, parameter);
        }

        public TypeParameter get(TypeVariable variable) {
            if (!this.typeVariables.containsKey(variable)) {
                throw new IllegalStateException("Could not find type variable " + variable.getName());
            }
            return this.typeVariables.get(variable);
        }
    }
}

