/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;
import org.openzen.zenscript.codemodel.type.storage.AutoStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.codemodel.type.storage.ValueStorageTag;

public class StoredType {
    public static final StoredType[] NONE = new StoredType[0];
    public final TypeID type;
    private final StorageTag storage;

    public static Map<TypeParameter, StoredType> getMapping(TypeParameter[] parameters, StoredType[] arguments) {
        HashMap<TypeParameter, StoredType> typeArguments = new HashMap<TypeParameter, StoredType>();
        for (int i = 0; i < parameters.length; ++i) {
            typeArguments.put(parameters[i], arguments[i]);
        }
        return typeArguments;
    }

    public static Map<TypeParameter, StoredType> getSelfMapping(GlobalTypeRegistry registry, TypeParameter[] parameters) {
        HashMap<TypeParameter, StoredType> typeArguments = new HashMap<TypeParameter, StoredType>();
        for (TypeParameter parameter : parameters) {
            typeArguments.put(parameter, registry.getGeneric(parameter).stored(parameter.storage));
        }
        return typeArguments;
    }

    public StoredType(TypeID type, StorageTag storage) {
        if (storage == ValueStorageTag.INSTANCE) {
            throw new IllegalArgumentException("storage of a nonvalue type cannot be value");
        }
        this.type = type;
        this.storage = storage;
    }

    public StorageTag getSpecifiedStorage() {
        return this.storage;
    }

    public StorageTag getActualStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        return this.type.isValueType() ? ValueStorageTag.INSTANCE : AutoStorageTag.INSTANCE;
    }

    public StoredType getNormalized() {
        return this.type.getNormalized() == this.type ? this : new StoredType(this.type.getNormalized(), this.storage);
    }

    public StoredType getSuperType(GlobalTypeRegistry registry) {
        TypeID superType = this.type.getSuperType(registry);
        return superType == null ? null : superType.stored(this.storage);
    }

    public StoredType instance(GenericMapper mapper) {
        return this.type.instance(mapper, this.storage);
    }

    public boolean isDestructible() {
        return this.type.isDestructible() && this.getActualStorage().isDestructible();
    }

    public boolean isDestructible(Set<HighLevelDefinition> scanning) {
        return this.type.isDestructible(scanning) && this.getActualStorage().isDestructible();
    }

    public boolean hasDefaultValue() {
        return this.type.hasDefaultValue();
    }

    public boolean isOptional() {
        return this.type.isOptional();
    }

    public boolean isConst() {
        return this.getActualStorage().isConst();
    }

    public boolean isImmutable() {
        return this.getActualStorage().isImmutable();
    }

    public boolean isBasic(BasicTypeID type) {
        return this.type == type;
    }

    public boolean isGeneric() {
        return this.type.isGeneric();
    }

    public StoredType withoutOptional() {
        return new StoredType(this.type.withoutOptional(), this.storage);
    }

    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] parameters) {
        return this.type.hasInferenceBlockingTypeParameters(parameters);
    }

    public Map<TypeParameter, StoredType> inferTypeParameters(LocalMemberCache cache, StoredType targetType) {
        return this.type.inferTypeParameters(cache, targetType);
    }

    public boolean isVariant() {
        return this.type.isVariant();
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public DefinitionTypeID asDefinition() {
        return (DefinitionTypeID)this.type;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.type);
        hash = 41 * hash + Objects.hashCode(this.storage);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StoredType other = (StoredType)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.storage, other.storage);
    }

    public String toString() {
        return this.storage == null ? this.type.toString() : this.type.toString(this.storage);
    }
}

