/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type.member;

import java.util.Arrays;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.AssocTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.FunctionTypeID;
import org.openzen.zenscript.codemodel.type.GenericMapTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.IteratorTypeID;
import org.openzen.zenscript.codemodel.type.OptionalTypeID;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.StringTypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;

public class TagRemovingTypeVisitor
implements TypeVisitor<StoredType> {
    private final LocalMemberCache cache;

    public TagRemovingTypeVisitor(LocalMemberCache cache) {
        this.cache = cache;
    }

    @Override
    public StoredType visitBasic(BasicTypeID basic) {
        return basic.stored;
    }

    @Override
    public StoredType visitString(StringTypeID string) {
        return string.stored();
    }

    @Override
    public StoredType visitArray(ArrayTypeID array) {
        return new ArrayTypeID(this.cache.getRegistry(), array.elementType.type.accept(this), array.dimension).stored();
    }

    @Override
    public StoredType visitAssoc(AssocTypeID assoc) {
        return new AssocTypeID(this.cache.getRegistry(), assoc.keyType.type.accept(this), assoc.valueType.type.accept(this)).stored();
    }

    @Override
    public StoredType visitGenericMap(GenericMapTypeID map) {
        return new GenericMapTypeID(this.cache.getRegistry(), map.value.type.accept(this), map.key).stored();
    }

    @Override
    public StoredType visitIterator(IteratorTypeID iterator) {
        return new IteratorTypeID(this.cache.getRegistry(), (StoredType[])Arrays.stream(iterator.iteratorTypes).map(storedType -> storedType.type).map(typeID -> typeID.accept(this)).toArray(StoredType[]::new)).stored();
    }

    @Override
    public StoredType visitFunction(FunctionTypeID function) {
        return function.stored();
    }

    @Override
    public StoredType visitDefinition(DefinitionTypeID definition) {
        return definition.stored();
    }

    @Override
    public StoredType visitGeneric(GenericTypeID generic) {
        return generic.stored();
    }

    @Override
    public StoredType visitRange(RangeTypeID range) {
        return new RangeTypeID((GlobalTypeRegistry)this.cache.getRegistry(), (StoredType)range.baseType.type.accept(this)).stored;
    }

    @Override
    public StoredType visitOptional(OptionalTypeID type) {
        return new OptionalTypeID(this.cache.getRegistry(), type.baseType.accept(this).type).stored();
    }
}

