/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.formattershared;

import org.openzen.zenscript.formattershared.CommentFormatter;
import stdlib.Chars;

public class FormattingSettings {
    public final boolean useTabs;
    public final int spacesPerTab;
    public final String indent;
    public final CommentFormatter commentFormatter;

    protected FormattingSettings(Builder builder) {
        this.useTabs = builder.useTabs;
        this.spacesPerTab = builder.spacesPerTab;
        this.commentFormatter = builder.commentFormatter;
        this.indent = this.useTabs ? "\t" : Chars.times(' ', this.spacesPerTab);
    }

    public static class Builder<T extends Builder<T>> {
        private final CommentFormatter commentFormatter;
        private boolean useTabs = false;
        private int spacesPerTab = 4;
        protected T instance;

        public Builder(CommentFormatter commentFormatter) {
            this.commentFormatter = commentFormatter;
        }

        public T useTabs(boolean tabs) {
            this.useTabs = tabs;
            return this.instance;
        }

        public T spacesPerTabs(int spaces) {
            this.spacesPerTab = spaces;
            return this.instance;
        }

        public FormattingSettings build() {
            return new FormattingSettings(this);
        }
    }
}

