/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.expression.AndAndExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class ParsedExpressionAndAnd
extends ParsedExpression {
    private final ParsedExpression left;
    private final ParsedExpression right;

    public ParsedExpressionAndAnd(CodePosition position, ParsedExpression left, ParsedExpression right) {
        super(position);
        this.left = left;
        this.right = right;
    }

    @Override
    public IPartialExpression compile(ExpressionScope scope) throws CompileException {
        Expression left = this.left.compile(scope).eval();
        Expression right = this.right.compile(scope).eval();
        StoredType resultType = scope.getTypeMembers(left.type).union(right.type);
        if (resultType == null) {
            throw new CompileException(this.position, CompileExceptionCode.TYPE_CANNOT_UNITE, "These types could not be unified: " + left.type + " and " + right.type);
        }
        left = left.castImplicit(this.position, scope, resultType);
        right = right.castImplicit(this.position, scope, resultType);
        return new AndAndExpression(this.position, left, right);
    }

    @Override
    public boolean hasStrongType() {
        return this.left.hasStrongType() && this.right.hasStrongType();
    }
}

