/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.InvalidAssignExpression;
import org.openzen.zenscript.codemodel.expression.InvalidExpression;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class ParsedExpressionAssign
extends ParsedExpression {
    private final ParsedExpression left;
    private final ParsedExpression right;

    public ParsedExpressionAssign(CodePosition position, ParsedExpression left, ParsedExpression right) {
        super(position);
        this.left = left;
        this.right = right;
    }

    @Override
    public IPartialExpression compile(ExpressionScope scope) throws CompileException {
        try {
            IPartialExpression cLeft = this.left.compile(scope);
            List<StoredType> resultHints = cLeft.getAssignHints();
            Expression cRight = this.right.compile(scope.withHints(resultHints)).eval();
            return cLeft.assign(this.position, scope, cRight);
        }
        catch (CompileException ex) {
            Expression cRight;
            InvalidExpression invalid = new InvalidExpression(BasicTypeID.VOID.stored, ex);
            try {
                cRight = this.right.compile(scope).eval();
            }
            catch (CompileException ex2) {
                cRight = new InvalidExpression(BasicTypeID.VOID.stored, ex2);
            }
            return new InvalidAssignExpression(this.position, invalid, cRight);
        }
    }

    @Override
    public boolean hasStrongType() {
        return this.right.hasStrongType();
    }
}

