/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.expression.ConstantCharExpression;
import org.openzen.zenscript.codemodel.expression.ConstantStringExpression;
import org.openzen.zenscript.codemodel.expression.switchvalue.CharSwitchValue;
import org.openzen.zenscript.codemodel.expression.switchvalue.StringSwitchValue;
import org.openzen.zenscript.codemodel.expression.switchvalue.SwitchValue;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.StringTypeID;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class ParsedExpressionString
extends ParsedExpression {
    public final String value;
    public final boolean singleQuote;

    public ParsedExpressionString(CodePosition position, String value, boolean singleQuote) {
        super(position);
        this.value = value;
        this.singleQuote = singleQuote;
    }

    @Override
    public IPartialExpression compile(ExpressionScope scope) {
        if (this.value.length() == 1 && (this.singleQuote || scope.hints.contains(BasicTypeID.CHAR.stored))) {
            return new ConstantCharExpression(this.position, this.value.charAt(0));
        }
        return new ConstantStringExpression(this.position, this.value);
    }

    @Override
    public SwitchValue compileToSwitchValue(StoredType type, ExpressionScope scope) throws CompileException {
        if (type.isBasic(BasicTypeID.CHAR)) {
            if (this.value.length() != 1) {
                throw new CompileException(this.position, CompileExceptionCode.INVALID_SWITCH_CASE, "char value expected but string given");
            }
            return new CharSwitchValue(this.value.charAt(0));
        }
        if (type.type instanceof StringTypeID) {
            return new StringSwitchValue(this.value);
        }
        throw new CompileException(this.position, CompileExceptionCode.INVALID_SWITCH_CASE, "Can only use string keys for string values");
    }

    @Override
    public boolean hasStrongType() {
        return false;
    }
}

