/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.type;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.context.TypeResolutionContext;
import org.openzen.zenscript.codemodel.type.InvalidTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;
import org.openzen.zenscript.parser.definitions.ParsedFunctionHeader;
import org.openzen.zenscript.parser.type.IParsedType;
import org.openzen.zenscript.parser.type.ParsedStorageTag;

public class ParsedFunctionType
implements IParsedType {
    private final CodePosition position;
    private final ParsedFunctionHeader header;
    private final ParsedStorageTag storage;

    public ParsedFunctionType(CodePosition position, ParsedFunctionHeader header, ParsedStorageTag storage) {
        this.position = position;
        this.header = header;
        this.storage = storage;
    }

    @Override
    public StoredType compile(TypeResolutionContext context) {
        StorageTag storage = this.storage.resolve(this.position, context);
        return context.getTypeRegistry().getFunction(this.header.compile(context)).stored(storage);
    }

    @Override
    public TypeID compileUnstored(TypeResolutionContext context) {
        if (this.storage != ParsedStorageTag.NULL) {
            return new InvalidTypeID(this.position, CompileExceptionCode.STORAGE_NOT_SUPPORTED, "Storage tag not supported here");
        }
        return context.getTypeRegistry().getFunction(this.header.compile(context));
    }
}

