/*
 * Decompiled with CFR 0.152.
 */
package stdlib;

import java.util.function.Function;

public abstract class Result<T, E> {
    public <R> Result<R, E> then(Class<R> typeOfR, Function<T, Result<R, E>> fn) {
        Result<R, E> temp1;
        switch (this.getDiscriminant()) {
            case Ok: {
                Object result = ((Ok)this).value;
                temp1 = fn.apply(result);
                break;
            }
            case Error: {
                Object error = ((Error)this).value;
                temp1 = new Error<R, E>(error);
                break;
            }
            default: {
                throw new AssertionError((Object)"Missing case");
            }
        }
        return temp1;
    }

    public <X> Result<T, X> handle(Class<X> typeOfX, Function<E, Result<T, X>> handler) {
        Result temp1;
        switch (this.getDiscriminant()) {
            case Ok: {
                Object result = ((Ok)this).value;
                temp1 = new Ok(result);
                break;
            }
            case Error: {
                Object error = ((Error)this).value;
                temp1 = handler.apply(error);
                break;
            }
            default: {
                throw new AssertionError((Object)"Missing case");
            }
        }
        return temp1;
    }

    public T expect() {
        Object temp1;
        switch (this.getDiscriminant()) {
            case Ok: {
                Object result;
                temp1 = result = ((Ok)this).value;
                break;
            }
            case Error: {
                Object error = ((Error)this).value;
                throw new AssertionError((Object)"expect() called on an error value");
            }
            default: {
                throw new AssertionError((Object)"Missing case");
            }
        }
        return temp1;
    }

    public T orElse(T other) {
        Object temp1;
        switch (this.getDiscriminant()) {
            case Ok: {
                Object result;
                temp1 = result = ((Ok)this).value;
                break;
            }
            case Error: {
                Object error = ((Error)this).value;
                temp1 = other;
                break;
            }
            default: {
                throw new AssertionError((Object)"Missing case");
            }
        }
        return temp1;
    }

    public T orElse(Function<E, T> other) {
        Object temp1;
        switch (this.getDiscriminant()) {
            case Ok: {
                Object result;
                temp1 = result = ((Ok)this).value;
                break;
            }
            case Error: {
                Object error = ((Error)this).value;
                temp1 = other.apply(error);
                break;
            }
            default: {
                throw new AssertionError((Object)"Missing case");
            }
        }
        return temp1;
    }

    public abstract Discriminant getDiscriminant();

    public static <T, E extends Exception> T unwrap(Class<T> typeOfT, Class<E> typeOfE, Result<T, E> self) throws E {
        Object temp1;
        switch (self.getDiscriminant()) {
            case Ok: {
                Object result;
                temp1 = result = ((Ok)self).value;
                break;
            }
            case Error: {
                Exception error = (Exception)((Error)self).value;
                throw error;
            }
            default: {
                throw new AssertionError((Object)"Missing case");
            }
        }
        return temp1;
    }

    public static class Error<T, E>
    extends Result<T, E> {
        public final E value;

        public Error(E value) {
            this.value = value;
        }

        @Override
        public Discriminant getDiscriminant() {
            return Discriminant.Error;
        }
    }

    public static class Ok<T, E>
    extends Result<T, E> {
        public final T value;

        public Ok(T value) {
            this.value = value;
        }

        @Override
        public Discriminant getDiscriminant() {
            return Discriminant.Ok;
        }
    }

    public static enum Discriminant {
        Ok,
        Error;

    }
}

