/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.mixin;

import fuzs.easymagic.registry.ModRegistry;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.easymagic.world.level.block.entity.ModEnchantmentTableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentTableBlock.class}, priority=1001)
public abstract class EnchantmentTableBlockMixin
extends BaseEntityBlock {
    protected EnchantmentTableBlockMixin(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Inject(method={"newBlockEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void newBlockEntity(BlockPos pPos, BlockState pState, CallbackInfoReturnable<BlockEntity> callbackInfo) {
        callbackInfo.setReturnValue((Object)new ModEnchantmentTableBlockEntity(pPos, pState));
    }

    @Inject(method={"getTicker"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends BlockEntity> void getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType, CallbackInfoReturnable<BlockEntityTicker<T>> callbackInfo) {
        callbackInfo.setReturnValue(pLevel.f_46443_ ? EnchantmentTableBlockMixin.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModRegistry.ENCHANTING_TABLE_BLOCK_ENTITY_TYPE.get()), EnchantmentTableBlockEntity::m_155503_) : null);
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> callbackInfo) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (!worldIn.f_46443_ && tileentity instanceof ModEnchantmentTableBlockEntity) {
            player.m_5893_((MenuProvider)tileentity);
            if (player.f_36096_ instanceof ModEnchantmentMenu) {
                player.f_36096_.m_6199_((Container)tileentity);
            }
            callbackInfo.setReturnValue((Object)InteractionResult.CONSUME);
        }
    }

    @Redirect(method={"animateTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isEmptyBlock(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean isBlockEmpty(Level world, BlockPos pos) {
        return ModEnchantmentMenu.isBlockEmpty(world, pos);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity;
        if (!state.m_60713_(newState.m_60734_()) && (tileentity = worldIn.m_7702_(pos)) instanceof ModEnchantmentTableBlockEntity) {
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((Container)tileentity));
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof Container) {
            ItemStack catalystItem = ((Container)tileentity).m_8020_(1);
            return Math.min(catalystItem.m_41613_(), 3);
        }
        return 0;
    }
}

