/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.network.message;

import fuzs.easymagic.client.gui.screens.inventory.ModEnchantmentScreen;
import fuzs.puzzleslib.network.message.Message;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class S2CEnchantingDataMessage
implements Message {
    private int containerId;
    private List<EnchantmentInstance> firstSlotData;
    private List<EnchantmentInstance> secondSlotData;
    private List<EnchantmentInstance> thirdSlotData;

    public S2CEnchantingDataMessage() {
    }

    public S2CEnchantingDataMessage(int containerId, List<EnchantmentInstance> firstSlotData, List<EnchantmentInstance> secondSlotData, List<EnchantmentInstance> thirdSlotData) {
        this.containerId = containerId;
        this.firstSlotData = firstSlotData;
        this.secondSlotData = secondSlotData;
        this.thirdSlotData = thirdSlotData;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.containerId);
        this.writeEnchantmentInstance(buf, this.firstSlotData);
        this.writeEnchantmentInstance(buf, this.secondSlotData);
        this.writeEnchantmentInstance(buf, this.thirdSlotData);
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.readByte();
        this.firstSlotData = this.readEnchantmentInstance(buf);
        this.secondSlotData = this.readEnchantmentInstance(buf);
        this.thirdSlotData = this.readEnchantmentInstance(buf);
    }

    private void writeEnchantmentInstance(FriendlyByteBuf buf, List<EnchantmentInstance> dataList) {
        buf.writeByte(dataList.size());
        for (EnchantmentInstance data : dataList) {
            buf.writeInt(((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)data.f_44947_));
            buf.writeShort(data.f_44948_);
        }
    }

    private List<EnchantmentInstance> readEnchantmentInstance(FriendlyByteBuf buf) {
        int listSize = buf.readByte();
        ArrayList<EnchantmentInstance> slotData = new ArrayList<EnchantmentInstance>(listSize);
        for (int i = 0; i < listSize; ++i) {
            Enchantment enchantment = (Enchantment)((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(buf.readInt());
            slotData.add(new EnchantmentInstance(enchantment, (int)buf.readShort()));
        }
        return slotData;
    }

    public EnchantingDataHandler makeHandler() {
        return new EnchantingDataHandler();
    }

    private static class EnchantingDataHandler
    extends Message.PacketHandler<S2CEnchantingDataMessage> {
        private EnchantingDataHandler() {
        }

        public void handle(S2CEnchantingDataMessage packet, Player player, Object gameInstance) {
            Screen screen = ((Minecraft)gameInstance).f_91080_;
            if (screen instanceof ModEnchantmentScreen) {
                ModEnchantmentScreen screen2 = (ModEnchantmentScreen)screen;
                if (player.f_36096_.f_38840_ == packet.containerId) {
                    screen2.setSlotData(0, packet.firstSlotData);
                    screen2.setSlotData(1, packet.secondSlotData);
                    screen2.setSlotData(2, packet.thirdSlotData);
                }
            }
        }
    }
}

