/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemLightLevels {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, Map<Item, Integer>> cache = new HashMap<String, Map<Item, Integer>>();

    public static void clearCache() {
        LOGGER.info("Clearing item tag to light level mapping cache");
        cache.clear();
    }

    public static int getLightFromItemStack(ItemStack stack, String tagName) {
        if (stack == null || stack.m_41619_()) {
            return 0;
        }
        Map innerCache = cache.computeIfAbsent(tagName, s -> new HashMap());
        return innerCache.computeIfAbsent(stack.m_41720_(), item1 -> stack.m_41720_().getTags().stream().map(t -> ItemLightLevels.getLightLevelByTagName(t.toString(), tagName)).filter(t -> t > 0 && t <= 15).max(Integer::compareTo).orElse(0));
    }

    private static int getLightLevelByTagName(String testee, String tagName) {
        String prefix = "dynamiclights:" + tagName;
        if (!testee.startsWith(prefix)) {
            return 0;
        }
        if (testee.equals(prefix)) {
            return 15;
        }
        int level = 0;
        try {
            String suffix = testee.substring(prefix.length() + 1);
            level = Integer.parseInt(suffix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return level;
    }
}

