/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server.modules;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.GsonConfig;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import atomicstryker.dynamiclights.server.ItemConfigHelper;
import atomicstryker.dynamiclights.server.ItemLightLevels;
import atomicstryker.dynamiclights.server.modules.LightConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerSelfLightSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ItemConfigHelper itemsMap;
    private static ItemConfigHelper notWaterProofItems;
    private LightConfig config;
    private final HashMap<Player, PlayerLightSourceContainer> playerLightsMap = new HashMap();

    public PlayerSelfLightSource() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverStartEvent(ServerAboutToStartEvent event) {
        LightConfig defaultConfig = new LightConfig();
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.f_50081_), 14));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.f_50141_), 15));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.f_50081_), 0));
        MinecraftServer server = event.getServer();
        File configFile = new File(server.m_129971_(""), File.separatorChar + "config" + File.separatorChar + "dynamiclights_selflight.cfg");
        try {
            this.config = GsonConfig.loadConfigWithDefault(LightConfig.class, configFile, defaultConfig);
            if (this.config == null) {
                throw new UnsupportedOperationException("PlayerSelfLightSource failed parsing config file somehow...");
            }
            itemsMap = new ItemConfigHelper(this.config.getItemsList(), LOGGER);
            notWaterProofItems = new ItemConfigHelper(this.config.getNotWaterProofList(), LOGGER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        if (event.player.m_6084_()) {
            PlayerLightSourceContainer playerLightSourceContainer = this.playerLightsMap.get(event.player);
            if (playerLightSourceContainer == null) {
                LOGGER.trace("built new PlayerLightSourceContainer for player {}", (Object)event.player);
                playerLightSourceContainer = new PlayerLightSourceContainer(event.player);
                this.playerLightsMap.put(event.player, playerLightSourceContainer);
            }
            int prevLight = playerLightSourceContainer.lightLevel;
            boolean isUnderwater = this.checkPlayerWater(event.player);
            ItemStack item = ItemStack.f_41583_;
            LOGGER.trace("checking for light from main hand item {}", (Object)event.player.m_21120_(InteractionHand.MAIN_HAND));
            int main = this.getLightFromItemStack(event.player.m_21120_(InteractionHand.MAIN_HAND), isUnderwater);
            int off = this.getLightFromItemStack(event.player.m_21120_(InteractionHand.OFF_HAND), isUnderwater);
            if (main >= off && main > 0) {
                item = event.player.m_21120_(InteractionHand.MAIN_HAND);
                playerLightSourceContainer.lightLevel = main;
            } else if (off >= main && off > 0) {
                item = event.player.m_21120_(InteractionHand.OFF_HAND);
                playerLightSourceContainer.lightLevel = off;
            } else {
                playerLightSourceContainer.lightLevel = 0;
            }
            LOGGER.trace("Self light tick, main:{}, off:{}, light:{}, chosen itemstack:{}", (Object)main, (Object)off, (Object)playerLightSourceContainer.lightLevel, (Object)item);
            for (ItemStack armor : event.player.m_150109_().f_35975_) {
                playerLightSourceContainer.lightLevel = Math.max(playerLightSourceContainer.lightLevel, this.getLightFromItemStack(armor, isUnderwater));
            }
            if (prevLight != 0 && playerLightSourceContainer.lightLevel != prevLight) {
                playerLightSourceContainer.lightLevel = 0;
            } else if (event.player.m_6060_()) {
                playerLightSourceContainer.lightLevel = 15;
            }
            if (!playerLightSourceContainer.enabled && playerLightSourceContainer.lightLevel > 0) {
                this.enableLight(playerLightSourceContainer);
            } else if (playerLightSourceContainer.enabled && playerLightSourceContainer.lightLevel < 1) {
                this.disableLight(playerLightSourceContainer);
            }
        } else {
            PlayerLightSourceContainer playerLightSourceContainer = this.playerLightsMap.get(event.player);
            if (playerLightSourceContainer != null) {
                this.disableLight(playerLightSourceContainer);
                this.playerLightsMap.remove(playerLightSourceContainer.thePlayer);
            }
        }
    }

    private boolean checkPlayerWater(Player thePlayer) {
        return thePlayer.m_19941_((Tag)FluidTags.f_13131_);
    }

    private int getLightFromItemStack(ItemStack stack, boolean isUnderwater) {
        if (isUnderwater && notWaterProofItems.getLightLevel(stack) > 0 || stack.m_41720_().getTags().contains(DynamicLights.NOT_WATERPROOF_TAG)) {
            return 0;
        }
        int level = ItemLightLevels.getLightFromItemStack(stack, "self");
        if (level > 0 && level <= 15) {
            return level;
        }
        return itemsMap.getLightLevel(stack);
    }

    private void enableLight(PlayerLightSourceContainer container) {
        DynamicLights.addLightSource(container);
        container.enabled = true;
    }

    private void disableLight(PlayerLightSourceContainer container) {
        DynamicLights.removeLightSource(container);
        container.enabled = false;
    }

    class PlayerLightSourceContainer
    implements IDynamicLightSource {
        int lightLevel;
        boolean enabled;
        Player thePlayer;

        PlayerLightSourceContainer(Player player) {
            this.thePlayer = player;
            this.lightLevel = 0;
            this.enabled = false;
        }

        @Override
        public Entity getAttachmentEntity() {
            return this.thePlayer;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }
}

