/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.randomium.block;

import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.mehvahdjukaar.randomium.Randomium;
import net.mehvahdjukaar.randomium.configs.CommonConfigs;
import net.mehvahdjukaar.randomium.entity.MovingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RandomiumOreBlock
extends Block {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    private double total = 0.0;
    private final NavigableMap<Double, Direction> map = new TreeMap<Double, Direction>(){
        {
            this.put(RandomiumOreBlock.this.total += (double)((Integer)CommonConfigs.FLY_CHANCE.get()).intValue(), Direction.UP);
            this.put(RandomiumOreBlock.this.total += (double)((Integer)CommonConfigs.FALL_CHANCE.get()).intValue(), Direction.DOWN);
            this.put(RandomiumOreBlock.this.total += (double)((Integer)CommonConfigs.MOVE_CHANCE.get()).intValue() / 4.0, Direction.NORTH);
            this.put(RandomiumOreBlock.this.total += (double)((Integer)CommonConfigs.MOVE_CHANCE.get()).intValue() / 4.0, Direction.SOUTH);
            this.put(RandomiumOreBlock.this.total += (double)((Integer)CommonConfigs.MOVE_CHANCE.get()).intValue() / 4.0, Direction.EAST);
            this.put(RandomiumOreBlock.this.total += (double)((Integer)CommonConfigs.MOVE_CHANCE.get()).intValue() / 4.0, Direction.WEST);
            this.put(RandomiumOreBlock.this.total += (double)((Integer)CommonConfigs.TELEPORT_CHANCE.get()).intValue(), null);
        }
    };

    public RandomiumOreBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(s -> (Boolean)s.m_61143_((Property)LIT) != false ? 4 : 0));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getRandomDrops(state, (Level)builder.m_78962_(), (ItemStack)builder.m_78982_(LootContextParams.f_81463_), (Entity)builder.m_78982_(LootContextParams.f_81455_));
    }

    public List<ItemStack> getRandomDrops(BlockState state, Level world, @Nullable ItemStack tool, @Nullable Entity entity) {
        double percentage = (Double)CommonConfigs.BASE_DROP_CHANCE.get();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            if (le.m_21023_(MobEffects.f_19621_)) {
                percentage += (double)le.m_21124_(MobEffects.f_19621_).m_19564_() * (Double)CommonConfigs.LUCK_MULTIPLIER.get();
            }
            if (le.m_21023_(MobEffects.f_19590_)) {
                percentage -= (double)le.m_21124_(MobEffects.f_19590_).m_19564_() * (Double)CommonConfigs.LUCK_MULTIPLIER.get();
            }
            if (tool != null) {
                int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
                percentage += (Double)CommonConfigs.FORTUNE_MULTIPLIER.get() * (double)fortune;
            }
        }
        ItemStack loot = (double)(world.f_46441_.nextFloat() * 100.0f) <= percentage ? new ItemStack((ItemLike)Randomium.RANDOMIUM_ITEM.get()) : (tool != null && (Boolean)CommonConfigs.ALLOW_SILK_TOUCH.get() != false && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) != 0 ? new ItemStack((ItemLike)this.m_5456_()) : Randomium.getRandomItem(world.f_46441_));
        return Collections.singletonList(loot);
    }

    public int getExpDrop(BlockState state, LevelReader world, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? Mth.m_14072_((Random)this.RANDOM, (int)0, (int)6) : 0;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return Randomium.getRandomSound(this.RANDOM);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        if (world instanceof Level) {
            Level level = (Level)world;
            return (float)Math.max(0.0, level.f_46441_.nextGaussian() * 6.0 + 8.0);
        }
        return 6.0f;
    }

    public Random getBlockRandom(BlockPos pos) {
        return new Random(this.getBlockSeed(pos));
    }

    public Long getBlockSeed(BlockPos pos) {
        return Mth.m_14057_((Vec3i)pos);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return this.getBlockRandom(pos).nextInt(16);
    }

    public int getGravityType(BlockPos pos) {
        long seed = this.getBlockSeed(pos);
        if (seed % 3L == 0L) {
            return 1;
        }
        return 0;
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player entity) {
        ItemStack tool = entity.m_21211_();
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool);
        double c = i != 0 ? (Double)CommonConfigs.SILK_TOUCH_MULTIPLIER.get() : 1.0;
        this.excite(state, world, pos, c * (double)((Integer)CommonConfigs.EXCITE_ON_ATTACK_CHANCE.get()).intValue());
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        this.excite(state, world, pos, ((Integer)CommonConfigs.EXCITE_ON_BLOCK_UPDATE_CHANCE.get()).intValue());
    }

    public void excite(BlockState state, Level world, BlockPos pos, double chance) {
        if (!world.f_46443_) {
            if ((double)world.f_46441_.nextFloat() < chance / 100.0) {
                Direction dir = this.map.higherEntry(world.f_46441_.nextDouble() * this.total).getValue();
                if (dir == null) {
                    this.teleport(state, (ServerLevel)world, pos);
                } else {
                    this.move(state, world, pos, dir);
                }
            } else if (world.f_46441_.nextInt(5) == 0) {
                this.lightUp(state, world, pos);
            }
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos end, int eventID, int eventParam) {
        if (eventID == 0) {
            Random random = world.f_46441_;
            int dx = (eventParam & 0xFF) - 64;
            int dy = (eventParam >> 8 & 0xFF) - 64;
            int dz = (eventParam >> 16 & 0xFF) - 64;
            BlockPos start = new BlockPos(end.m_123341_() - dx, end.m_123342_() - dy, end.m_123343_() - dz);
            for (int j = 0; j < 64; ++j) {
                double d0 = random.nextDouble();
                float f = (random.nextFloat() - 0.5f) * 0.2f;
                float f1 = (random.nextFloat() - 0.5f) * 0.2f;
                float f2 = (random.nextFloat() - 0.5f) * 0.2f;
                double d1 = Mth.m_14139_((double)d0, (double)end.m_123341_(), (double)start.m_123341_()) + (random.nextDouble() - 0.5) + 0.5;
                double d2 = Mth.m_14139_((double)d0, (double)end.m_123342_(), (double)start.m_123342_()) + random.nextDouble() - 0.5;
                double d3 = Mth.m_14139_((double)d0, (double)end.m_123343_(), (double)start.m_123343_()) + (random.nextDouble() - 0.5) + 0.5;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d1, d2, d3, (double)f, (double)f1, (double)f2);
            }
            return true;
        }
        return super.m_8133_(state, world, end, eventID, eventParam);
    }

    private void teleport(BlockState state, ServerLevel world, BlockPos pos) {
        int range = 7;
        for (int i = 0; i < 1000; ++i) {
            BlockPos blockpos = pos.m_142082_(world.f_46441_.nextInt(7) - world.f_46441_.nextInt(7), world.f_46441_.nextInt(3) - world.f_46441_.nextInt(3), world.f_46441_.nextInt(7) - world.f_46441_.nextInt(7));
            if (!world.m_8055_(blockpos).m_60795_()) continue;
            int dx = (byte)(blockpos.m_123341_() - pos.m_123341_()) + 64;
            int dy = (byte)(blockpos.m_123342_() - pos.m_123342_()) + 64;
            int dz = (byte)(blockpos.m_123343_() - pos.m_123343_()) + 64;
            world.m_7731_(blockpos, state, 2);
            world.m_7471_(pos, false);
            world.m_7696_(blockpos, (Block)this, 0, (dz & 0xFF) << 16 | (dy & 0xFF) << 8 | dx & 0xFF);
            return;
        }
    }

    public void move(BlockState state, Level world, BlockPos pos, Direction dir) {
        if (FallingBlock.m_53241_((BlockState)world.m_8055_(pos.m_142300_(dir)))) {
            MovingBlockEntity entity = new MovingBlockEntity(world, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, state, dir);
            world.m_7967_((Entity)entity);
        }
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (pLevel.f_46441_.nextInt(5) == 0) {
            this.lightUp(pLevel.m_8055_(pPos), pLevel, pPos);
        }
        super.m_141947_(pLevel, pPos, pState, pEntity);
    }

    private void lightUp(BlockState state, Level world, BlockPos pos) {
        RandomiumOreBlock.spawnParticles(world, pos);
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public void m_7455_(BlockState state, ServerLevel serverWorld, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            serverWorld.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.FALSE), 2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            RandomiumOreBlock.spawnParticles(world, pos);
        }
    }

    private static void spawnParticles(Level world, BlockPos pos) {
        double d0 = 0.5625;
        Random random = world.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos;
            if (random.nextInt(5) != 0 || world.m_8055_(blockpos = pos.m_142300_(direction)).m_60804_((BlockGetter)world, blockpos)) continue;
            Direction.Axis direction$axis = direction.m_122434_();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)random.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.nextFloat();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123771_, (double)pos.m_123341_() + d1, (double)pos.m_123342_() + d2, (double)pos.m_123343_() + d3, 0.0, -0.1, 0.0);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return this.getBlockRandom(pos).nextInt(10) + 5;
        }
        return 0;
    }
}

