/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.randomium.recipes;

import net.mehvahdjukaar.randomium.Randomium;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.CapabilityItemHandler;

public class RandomiumDuplicateRecipe
extends CustomRecipe {
    public RandomiumDuplicateRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    private boolean isRandomium(ItemStack stack) {
        return stack.m_41720_() == Randomium.RANDOMIUM_ITEM.get();
    }

    private boolean canBeDuplicated(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                return false;
            }
            String s = tag.toString();
            if (s.contains("Items:[") || s.contains("BlockEntityTag") || s.contains("Inventory:[") || s.contains("Drawers:[") || s.contains(((Item)Randomium.RANDOMIUM_ORE_ITEM.get()).getRegistryName().toString()) || s.contains(((Item)Randomium.RANDOMIUM_END_ORE_ITEM.get()).getRegistryName().toString()) || s.contains(((Item)Randomium.RANDOMIUM_ITEM.get()).getRegistryName().toString())) {
                return false;
            }
        }
        return !stack.m_150922_(Randomium.BLACKLIST);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack toDuplicate = null;
        ItemStack randomium = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.isRandomium(stack)) {
                if (randomium != null) {
                    return false;
                }
                randomium = stack;
                continue;
            }
            if (this.canBeDuplicated(stack)) {
                if (toDuplicate != null) {
                    return false;
                }
                toDuplicate = stack;
                continue;
            }
            return false;
        }
        return toDuplicate != null && randomium != null;
    }

    public ItemStack assemble(CraftingContainer inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || this.isRandomium(stack) || !this.canBeDuplicated(stack)) continue;
            ItemStack s = stack.m_41777_();
            s.m_41764_(1);
            return s;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i).m_41777_();
            if (this.isRandomium(itemstack)) continue;
            itemstack.m_41764_(1);
            nonnulllist.set(i, (Object)itemstack);
        }
        return nonnulllist;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Randomium.RANDOMIUM_CLONE_RECIPE.get();
    }
}

