/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass;

import com.supermartijn642.connectedglass.CGColoredGlassBlock;
import com.supermartijn642.connectedglass.CGColoredPaneBlock;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.connectedglass.CGTintedGlassBlock;
import com.supermartijn642.connectedglass.ConnectedGlass;
import com.supermartijn642.connectedglass.model.CGBakedModel;
import com.supermartijn642.connectedglass.model.CGConnectedBakedModel;
import com.supermartijn642.connectedglass.model.CGConnectedPaneBakedModel;
import com.supermartijn642.connectedglass.model.CGPaneBakedModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    public static final Map<CGGlassBlock, TextureAtlasSprite> TEXTURES = new HashMap<CGGlassBlock, TextureAtlasSprite>();

    @SubscribeEvent
    public static void onBake(ModelBakeEvent e) {
        Object model;
        for (CGGlassBlock block : ConnectedGlass.BLOCKS) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)(block instanceof CGColoredGlassBlock || block instanceof CGTintedGlassBlock ? RenderType.m_110466_() : RenderType.m_110463_()));
            model = block.connected ? new CGConnectedBakedModel(block) : new CGBakedModel(block);
            e.getModelRegistry().put(new ModelResourceLocation(block.getRegistryName(), ""), model);
            e.getModelRegistry().put(new ModelResourceLocation(block.getRegistryName(), "inventory"), model);
        }
        Iterator<Object> iterator = ConnectedGlass.PANES.iterator();
        while (iterator.hasNext()) {
            CGPaneBlock pane;
            ItemBlockRenderTypes.setRenderLayer((Block)pane, (RenderType)((pane = (CGPaneBlock)((Object)iterator.next())) instanceof CGColoredPaneBlock ? RenderType.m_110466_() : RenderType.m_110457_()));
            model = pane.block.connected ? new CGConnectedPaneBakedModel(pane) : new CGPaneBakedModel(pane);
            e.getModelRegistry().put(new ModelResourceLocation(pane.getRegistryName(), "inventory"), model);
            pane.m_49965_().m_61056_().forEach(arg_0 -> ClientProxy.lambda$onBake$0(e, pane, (CGPaneBakedModel)model, arg_0));
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre e) {
        if (e.getAtlas().m_118330_().toString().equals("minecraft:textures/atlas/blocks.png")) {
            for (CGGlassBlock block : ConnectedGlass.BLOCKS) {
                e.addSprite(block.getRegistryName());
            }
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Post e) {
        if (e.getAtlas().m_118330_().toString().equals("minecraft:textures/atlas/blocks.png")) {
            for (CGGlassBlock block : ConnectedGlass.BLOCKS) {
                TEXTURES.put(block, e.getAtlas().m_118316_(block.getRegistryName()));
            }
        }
    }

    private static /* synthetic */ void lambda$onBake$0(ModelBakeEvent e, CGPaneBlock pane, CGPaneBakedModel model, BlockState state) {
        String variant = state.toString();
        variant = variant.indexOf(91) > 0 ? variant.substring(variant.indexOf(91) + 1, variant.length() - 1) : "";
        e.getModelRegistry().put(new ModelResourceLocation(pane.getRegistryName(), variant), model);
    }
}

