/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.data;

import com.supermartijn642.connectedglass.CGColoredGlassBlock;
import com.supermartijn642.connectedglass.CGColoredPaneBlock;
import com.supermartijn642.connectedglass.CGGlassBlock;
import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.CGPaneBlock;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CGRecipeProvider
extends RecipeProvider {
    private Block vanillaBlock;
    private final List<Block> vanillaBlocks = new ArrayList<Block>();
    private final EnumMap<DyeColor, Block> vanillaColoredBlocks = new EnumMap(DyeColor.class);
    private Block vanillaPane;
    private final List<Block> vanillaPanes = new ArrayList<Block>();
    private final EnumMap<DyeColor, Block> vanillaColoredPanes = new EnumMap(DyeColor.class);

    public CGRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        Object previous;
        this.gatherVanillaBlocks();
        this.gatherVanillaPanes();
        CGGlassType lastType = null;
        CGGlassType lastTypeTinted = null;
        for (CGGlassType type : CGGlassType.values()) {
            DyeColor color;
            for (CGGlassBlock cGGlassBlock : type.blocks) {
                DyeColor dyeColor = color = cGGlassBlock instanceof CGColoredGlassBlock ? ((CGColoredGlassBlock)cGGlassBlock).m_7988_() : null;
                Object previous2 = type.isTinted ? (lastTypeTinted == null ? (color == null ? Blocks.f_152498_ : null) : lastTypeTinted.getBlock(color)) : (lastType == null ? this.getVanillaBlock(color) : lastType.getBlock(color));
                if (previous2 == null) continue;
                ShapedRecipeBuilder.m_126118_((ItemLike)cGGlassBlock, (int)4).m_126130_("GG").m_126130_("GG").m_126127_(Character.valueOf('G'), (ItemLike)previous2).m_142284_("glass", (CriterionTriggerInstance)CGRecipeProvider.m_125977_((ItemLike)previous2)).m_176500_(consumer, cGGlassBlock.getRegistryName() + "1");
            }
            for (CGColoredGlassBlock cGColoredGlassBlock : type.colored_blocks.values()) {
                ShapedRecipeBuilder.m_126118_((ItemLike)cGColoredGlassBlock, (int)8).m_126130_("GGG").m_126130_("GDG").m_126130_("GGG").m_126127_(Character.valueOf('G'), (ItemLike)type.block).m_206416_(Character.valueOf('D'), cGColoredGlassBlock.m_7988_().getTag()).m_142284_("glass", (CriterionTriggerInstance)CGRecipeProvider.m_125977_((ItemLike)type.block)).m_142284_("dye", (CriterionTriggerInstance)CGRecipeProvider.m_206406_((TagKey)cGColoredGlassBlock.m_7988_().getTag())).m_176500_(consumer, cGColoredGlassBlock.getRegistryName() + "2");
            }
            if (type.hasPanes) {
                for (CGPaneBlock cGPaneBlock : type.panes) {
                    DyeColor dyeColor = color = cGPaneBlock instanceof CGColoredPaneBlock ? ((CGColoredPaneBlock)cGPaneBlock).m_7988_() : null;
                    Object previous2 = type.isTinted ? (lastTypeTinted == null ? null : lastTypeTinted.getPane(color)) : (lastType == null ? this.getVanillaPane(color) : lastType.getPane(color));
                    if (previous2 == null) continue;
                    ShapedRecipeBuilder.m_126118_((ItemLike)cGPaneBlock, (int)4).m_126130_("GG").m_126130_("GG").m_126127_(Character.valueOf('G'), (ItemLike)previous2).m_142284_("glass_pane", (CriterionTriggerInstance)CGRecipeProvider.m_125977_((ItemLike)previous2)).m_176500_(consumer, cGPaneBlock.getRegistryName() + "1");
                }
                for (CGColoredPaneBlock cGColoredPaneBlock : type.colored_panes.values()) {
                    ShapedRecipeBuilder.m_126118_((ItemLike)cGColoredPaneBlock, (int)8).m_126130_("GGG").m_126130_("GDG").m_126130_("GGG").m_126127_(Character.valueOf('G'), (ItemLike)type.pane).m_206416_(Character.valueOf('D'), cGColoredPaneBlock.m_7988_().getTag()).m_142284_("glass_pane", (CriterionTriggerInstance)CGRecipeProvider.m_125977_((ItemLike)type.pane)).m_142284_("dye", (CriterionTriggerInstance)CGRecipeProvider.m_206406_((TagKey)cGColoredPaneBlock.m_7988_().getTag())).m_176500_(consumer, cGColoredPaneBlock.getRegistryName() + "2");
                }
                for (CGGlassBlock cGGlassBlock : type.blocks) {
                    color = cGGlassBlock instanceof CGColoredGlassBlock ? ((CGColoredGlassBlock)cGGlassBlock).m_7988_() : null;
                    CGPaneBlock pane = type.getPane(color);
                    ShapedRecipeBuilder.m_126118_((ItemLike)pane, (int)16).m_126130_("GGG").m_126130_("GGG").m_126127_(Character.valueOf('G'), (ItemLike)cGGlassBlock).m_142284_("glass", (CriterionTriggerInstance)CGRecipeProvider.m_125977_((ItemLike)cGGlassBlock)).m_176500_(consumer, pane.getRegistryName() + "3");
                }
            }
            if (type.isTinted) {
                lastTypeTinted = type;
                continue;
            }
            lastType = type;
        }
        for (Block block : this.vanillaBlocks) {
            DyeColor color = block instanceof BeaconBeamBlock ? ((BeaconBeamBlock)block).m_7988_() : null;
            previous = lastType.getBlock(color);
            ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)4).m_126130_("GG").m_126130_("GG").m_126127_(Character.valueOf('G'), (ItemLike)previous).m_142284_("glass", (CriterionTriggerInstance)CGRecipeProvider.m_125977_((ItemLike)previous)).m_142700_(consumer, new ResourceLocation("connectedglass", "vanilla_" + block.getRegistryName().m_135815_()));
        }
        for (Block pane : this.vanillaPanes) {
            DyeColor color = pane instanceof BeaconBeamBlock ? ((BeaconBeamBlock)pane).m_7988_() : null;
            previous = lastType.getPane(color);
            ShapedRecipeBuilder.m_126118_((ItemLike)pane, (int)4).m_126130_("GG").m_126130_("GG").m_126127_(Character.valueOf('G'), (ItemLike)previous).m_142284_("glass_pane", (CriterionTriggerInstance)CGRecipeProvider.m_125977_((ItemLike)previous)).m_142700_(consumer, new ResourceLocation("connectedglass", "vanilla_" + pane.getRegistryName().m_135815_()));
        }
        CGGlassBlock previous3 = lastTypeTinted.getBlock(null);
        ShapedRecipeBuilder.m_126118_((ItemLike)Blocks.f_152498_, (int)4).m_126130_("GG").m_126130_("GG").m_126127_(Character.valueOf('G'), (ItemLike)previous3).m_142284_("glass", (CriterionTriggerInstance)CGRecipeProvider.m_125977_((ItemLike)previous3)).m_142700_(consumer, new ResourceLocation("connectedglass", "vanilla_" + Blocks.f_152498_.getRegistryName().m_135815_()));
    }

    private void gatherVanillaBlocks() {
        this.addVanillaBlock(Blocks.f_50058_);
        this.addVanillaBlock(Blocks.f_50147_);
        this.addVanillaBlock(Blocks.f_50148_);
        this.addVanillaBlock(Blocks.f_50202_);
        this.addVanillaBlock(Blocks.f_50203_);
        this.addVanillaBlock(Blocks.f_50204_);
        this.addVanillaBlock(Blocks.f_50205_);
        this.addVanillaBlock(Blocks.f_50206_);
        this.addVanillaBlock(Blocks.f_50207_);
        this.addVanillaBlock(Blocks.f_50208_);
        this.addVanillaBlock(Blocks.f_50209_);
        this.addVanillaBlock(Blocks.f_50210_);
        this.addVanillaBlock(Blocks.f_50211_);
        this.addVanillaBlock(Blocks.f_50212_);
        this.addVanillaBlock(Blocks.f_50213_);
        this.addVanillaBlock(Blocks.f_50214_);
        this.addVanillaBlock(Blocks.f_50215_);
    }

    private void addVanillaBlock(Block block) {
        DyeColor color;
        this.vanillaBlocks.add(block);
        DyeColor dyeColor = color = block instanceof BeaconBeamBlock ? ((BeaconBeamBlock)block).m_7988_() : null;
        if (color == null) {
            this.vanillaBlock = block;
        } else {
            this.vanillaColoredBlocks.put(color, block);
        }
    }

    private void gatherVanillaPanes() {
        this.addVanillaPane(Blocks.f_50185_);
        this.addVanillaPane(Blocks.f_50303_);
        this.addVanillaPane(Blocks.f_50304_);
        this.addVanillaPane(Blocks.f_50305_);
        this.addVanillaPane(Blocks.f_50306_);
        this.addVanillaPane(Blocks.f_50307_);
        this.addVanillaPane(Blocks.f_50361_);
        this.addVanillaPane(Blocks.f_50362_);
        this.addVanillaPane(Blocks.f_50363_);
        this.addVanillaPane(Blocks.f_50364_);
        this.addVanillaPane(Blocks.f_50365_);
        this.addVanillaPane(Blocks.f_50366_);
        this.addVanillaPane(Blocks.f_50367_);
        this.addVanillaPane(Blocks.f_50368_);
        this.addVanillaPane(Blocks.f_50369_);
        this.addVanillaPane(Blocks.f_50370_);
        this.addVanillaPane(Blocks.f_50371_);
    }

    private void addVanillaPane(Block pane) {
        DyeColor color;
        this.vanillaPanes.add(pane);
        DyeColor dyeColor = color = pane instanceof BeaconBeamBlock ? ((BeaconBeamBlock)pane).m_7988_() : null;
        if (color == null) {
            this.vanillaPane = pane;
        } else {
            this.vanillaColoredPanes.put(color, pane);
        }
    }

    private Block getVanillaBlock(DyeColor color) {
        if (color == null) {
            return this.vanillaBlock;
        }
        return this.vanillaColoredBlocks.get(color);
    }

    private Block getVanillaPane(DyeColor color) {
        if (color == null) {
            return this.vanillaPane;
        }
        return this.vanillaColoredPanes.get(color);
    }

    private List<Block> getVanillaBlocks() {
        return this.vanillaBlocks;
    }

    private List<Block> getVanillaPanes() {
        return this.vanillaPanes;
    }

    public String m_6055_() {
        return "connectedglass:recipes";
    }
}

