/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.canvastracker;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.canvastracker.CanvasDefaultTracker;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.event.CanvasRegisterEvent;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CanvasClientTracker
extends CanvasDefaultTracker {
    private final Level world;
    Map<String, AbstractCanvasData> canvases = Maps.newHashMap();

    public CanvasClientTracker(Level world) {
        this.world = world;
    }

    @Override
    @Nullable
    public <T extends AbstractCanvasData> T getCanvasData(String canvasCode, @Nullable Class<T> type) {
        return (T)((Object)this.canvases.get(canvasCode));
    }

    @Override
    public void registerCanvasData(String newCanvasCode, AbstractCanvasData newCanvasData) {
        this.canvases.remove(newCanvasCode);
        this.canvases.put(newCanvasCode, newCanvasData);
        CanvasRenderer.getInstance().addCanvas(newCanvasCode, newCanvasData);
        CanvasRegisterEvent event = new CanvasRegisterEvent(newCanvasCode, newCanvasData);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public void unregisterCanvasData(String newCanvasCode) {
        this.canvases.remove(newCanvasCode);
        CanvasRenderer.getInstance().unloadCanvas(newCanvasCode);
    }

    @Override
    public Level getWorld() {
        return this.world;
    }
}

