/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.canvastracker;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.canvastracker.CanvasDefaultTracker;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.network.packet.SCanvasSyncMessage;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.PacketDistributor;

public class CanvasServerTracker
extends CanvasDefaultTracker {
    private final Level world;
    private int lastCanvasId;
    private int lastPaintingId;
    private final Map<String, Vector<PlayerTrackingCanvas>> trackedCanvases = new HashMap<String, Vector<PlayerTrackingCanvas>>();
    private final Vector<String> desyncCanvases = new Vector();
    private int ticksFromLastSync = 0;

    public CanvasServerTracker(Level world) {
        this.world = world;
        this.lastCanvasId = 0;
        this.lastPaintingId = 0;
    }

    @Override
    public Level getWorld() {
        return this.world;
    }

    @Override
    public int getNextCanvasId() {
        return ++this.lastCanvasId;
    }

    @Override
    public int getLastCanvasId() {
        return this.lastCanvasId;
    }

    @Override
    public void setLastCanvasId(int id) {
        this.lastCanvasId = id;
    }

    @Override
    public int getNextPaintingId() {
        return ++this.lastPaintingId;
    }

    @Override
    public int getLastPaintingId() {
        return this.lastPaintingId;
    }

    @Override
    public void setLastPaintingId(int id) {
        this.lastPaintingId = id;
    }

    public void markCanvasDesync(String canvasCode) {
        this.desyncCanvases.add(canvasCode);
    }

    @Override
    @Nullable
    public <T extends AbstractCanvasData> T getCanvasData(String canvasCode, @Nullable Class<T> type) {
        return (T)((Object)((AbstractCanvasData)this.world.m_142572_().m_129783_().m_8895_().m_164858_(compoundTag -> {
            if (type.equals(CanvasData.class)) {
                return CanvasData.createLoaded(compoundTag);
            }
            if (type.equals(PaintingData.class)) {
                return PaintingData.createLoaded(compoundTag);
            }
            return DummyCanvasData.createDummy();
        }, canvasCode)));
    }

    @Override
    public void registerCanvasData(String canvasCode, AbstractCanvasData canvasData) {
        if (canvasData instanceof DummyCanvasData) {
            Zetter.LOG.error("Trying to register dummy canvas on server side");
            return;
        }
        this.world.m_142572_().m_129783_().m_8895_().m_164855_(canvasCode, (SavedData)canvasData);
    }

    @Override
    public void unregisterCanvasData(String canvasCode) {
        Zetter.LOG.error("Trying to unregister canvas on server side, not supported yet");
    }

    public void tick() {
        ++this.ticksFromLastSync;
        if (this.ticksFromLastSync < 20) {
            return;
        }
        MinecraftServer server = this.world.m_142572_();
        for (String canvasCode : this.desyncCanvases) {
            for (PlayerTrackingCanvas playerTrackingCanvas : this.getTrackingEntries(canvasCode)) {
                ServerPlayer playerEntity = server.m_6846_().m_11259_(playerTrackingCanvas.playerId);
                SCanvasSyncMessage canvasSyncMessage = new SCanvasSyncMessage(canvasCode, this.getCanvasData(canvasCode, DummyCanvasData.class), System.currentTimeMillis());
                ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> playerEntity), (Object)canvasSyncMessage);
            }
        }
        this.desyncCanvases.clear();
        this.ticksFromLastSync = 0;
    }

    public void trackCanvas(UUID playerId, String canvasName) {
        Vector<PlayerTrackingCanvas> trackingEntries = this.getTrackingEntries(canvasName);
        for (PlayerTrackingCanvas playerTrackingCanvas : trackingEntries) {
            if (playerTrackingCanvas.playerId != playerId) continue;
            return;
        }
        trackingEntries.add(new PlayerTrackingCanvas(playerId, canvasName));
    }

    public void stopTrackingCanvas(UUID playerId, String canvasName) {
        Vector<PlayerTrackingCanvas> trackingEntries = this.getTrackingEntries(canvasName);
        trackingEntries.removeIf(entry -> entry.playerId == playerId);
    }

    public void stopTrackingAllCanvases(UUID playerId) {
        for (String canvasName : this.trackedCanvases.keySet()) {
            this.stopTrackingCanvas(playerId, canvasName);
        }
    }

    private Vector<PlayerTrackingCanvas> getTrackingEntries(String canvasName) {
        return this.trackedCanvases.computeIfAbsent(canvasName, k -> new Vector());
    }

    private static class PlayerTrackingCanvas {
        public final UUID playerId;
        public final String canvasName;

        PlayerTrackingCanvas(UUID playerId, String canvasName) {
            this.playerId = playerId;
            this.canvasName = canvasName;
        }
    }
}

