/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.canvastracker;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.canvastracker.CanvasClientTracker;
import me.dantaeusb.zetter.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.canvastracker.ICanvasTracker;
import me.dantaeusb.zetter.core.ZetterCapabilities;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CanvasTrackerProvider
implements ICapabilitySerializable<CompoundTag> {
    private final Direction NO_SPECIFIC_SIDE = null;
    private final ICanvasTracker canvasTrackerCapability;
    private final String TAG_NAME_CANVAS_TRACKER = "canvasTracker";

    public CanvasTrackerProvider(Level world) {
        this.canvasTrackerCapability = world.m_5776_() ? new CanvasClientTracker(world) : new CanvasServerTracker(world);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (ZetterCapabilities.CANVAS_TRACKER == capability) {
            return LazyOptional.of(() -> this.canvasTrackerCapability);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.canvasTrackerCapability.getWorld() == null || this.canvasTrackerCapability.getWorld().m_5776_()) {
            return nbt;
        }
        Tag canvasTrackerNBT = this.canvasTrackerCapability.serializeNBT();
        nbt.m_128365_("canvasTracker", canvasTrackerNBT);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (this.canvasTrackerCapability.getWorld() == null || this.canvasTrackerCapability.getWorld().m_5776_()) {
            return;
        }
        Tag canvasTrackerTag = nbt.m_128423_("canvasTracker");
        this.canvasTrackerCapability.deserializeNBT(canvasTrackerTag);
    }
}

