/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import me.dantaeusb.zetter.client.gui.artisttable.AbstractArtistTableWidget;
import me.dantaeusb.zetter.client.gui.artisttable.CombinedCanvasWidget;
import me.dantaeusb.zetter.client.gui.artisttable.HelpWidget;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.network.packet.CUpdatePaintingPacket;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ArtistTableScreen
extends AbstractContainerScreen<ArtistTableMenu> {
    protected final Component f_96539_ = new TranslatableComponent("container.zetter.artistTable");
    private EditBox nameField;
    private static final ResourceLocation ARTIST_TABLE_RESOURCE = new ResourceLocation("zetter", "textures/gui/artist_table.png");
    protected final List<AbstractArtistTableWidget> artistTableWidgets = Lists.newArrayList();
    private CombinedCanvasWidget combinedCanvasWidget;
    private HelpWidget helpWidget;
    private int tick = 0;
    final int INPUT_XPOS = 7;
    final int INPUT_YPOS = 107;
    final int INPUT_WIDTH = 95;
    final int INPUT_HEIGHT = 12;

    public ArtistTableScreen(ArtistTableMenu artistTableMenu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)artistTableMenu, playerInventory, title);
        this.f_97727_ = 220;
        this.f_97726_ = 176;
    }

    protected void m_7856_() {
        super.m_7856_();
        int COMBINED_CANVAS_POSITION_X = 104;
        int COMBINED_CANVAS_POSITION_Y = 26;
        int HELP_POSITION_X = 165;
        boolean HELP_POSITION_Y = false;
        this.combinedCanvasWidget = new CombinedCanvasWidget(this, this.getGuiLeft() + 104, this.getGuiTop() + 26);
        this.helpWidget = new HelpWidget(this, this.getGuiLeft() + 165, this.getGuiTop() + 0);
        this.addPaintingWidget(this.combinedCanvasWidget);
        this.addPaintingWidget(this.helpWidget);
        this.initFields();
    }

    public void addPaintingWidget(AbstractArtistTableWidget widget) {
        this.artistTableWidgets.add(widget);
        this.m_7787_(widget);
    }

    protected void initFields() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.nameField = new EditBox(this.f_96547_, this.f_97735_ + this.INPUT_XPOS + 4, this.f_97736_ + 107 + 4, 95, 12, (Component)new TranslatableComponent("container.zetter.artist_table"));
        this.nameField.m_94190_(false);
        this.nameField.m_94202_(-1);
        this.nameField.m_94205_(-1);
        this.nameField.m_94182_(false);
        this.nameField.m_94199_(35);
        this.nameField.m_94151_(this::renameItem);
        this.m_7787_((GuiEventListener)this.nameField);
        this.m_94718_((GuiEventListener)this.nameField);
    }

    private void renameItem(String name) {
        ((ArtistTableMenu)this.f_97732_).updatePaintingName(name);
        if (((ArtistTableMenu)this.m_6262_()).isCanvasReady()) {
            this.sendRenamePacket(name);
        }
    }

    private void sendRenamePacket(String name) {
        CUpdatePaintingPacket modePacket = new CUpdatePaintingPacket(((ArtistTableMenu)this.f_97732_).f_38840_, this.nameField.m_94155_(), ((ArtistTableMenu)this.f_97732_).getCanvasCombination().canvasData);
        ZetterNetwork.simpleChannel.sendToServer((Object)modePacket);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.renderNameField(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    public void renderNameField(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.nameField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void m_181908_() {
        super.m_181908_();
        ++this.tick;
        this.nameField.m_94120_();
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ARTIST_TABLE_RESOURCE);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        boolean INPUT_UPOS = false;
        int INPUT_VPOS = this.f_97727_;
        int INPUT_WIDTH = 100;
        int INPUT_HEIGHT = 16;
        this.m_93228_(matrixStack, this.f_97735_ + 7, this.f_97736_ + 107, 0, INPUT_VPOS + (this.allowedToNameItem() && this.nameField.m_93696_() ? 0 : 16), 100, 16);
        int LOADING_XPOS = 128;
        int LOADING_YPOS = 54;
        int LOADING_UPOS = 100;
        int LOADING_VPOS = this.f_97727_;
        int LOADING_WIDTH = 16;
        int LOADING_HEIGHT = 10;
        if (((ArtistTableMenu)this.m_6262_()).canvasLoading()) {
            int animation = this.tick % 40;
            int frame = animation / 10;
            frame = frame > 2 ? 1 : frame;
            this.m_93228_(matrixStack, this.f_97735_ + 128, this.f_97736_ + 54, 100, LOADING_VPOS + 10 * frame, 16, 10);
        }
        this.helpWidget.m_6305_(matrixStack, x, y, partialTicks);
        if (((ArtistTableMenu)this.m_6262_()).isCanvasReady()) {
            this.combinedCanvasWidget.render(matrixStack);
        }
    }

    protected void m_7025_(PoseStack matrixStack, int x, int y) {
        super.m_7025_(matrixStack, x, y);
        for (AbstractArtistTableWidget widget : this.artistTableWidgets) {
            Component tooltip;
            if (!widget.m_5953_(x, y) || (tooltip = widget.getTooltip(x, y)) == null) continue;
            this.m_96602_(matrixStack, tooltip, x, y);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        int LABEL_XPOS = 5;
        int LABEL_YPOS = 5;
        this.f_96547_.m_92889_(matrixStack, this.f_96539_, 5.0f, 5.0f, Color.darkGray.getRGB());
        int FONT_Y_SPACING = 10;
        int PLAYER_INV_LABEL_XPOS = 8;
        int PLAYER_INV_LABEL_YPOS = 128;
        this.f_96547_.m_92889_(matrixStack, this.f_169604_, 8.0f, 128.0f, Color.darkGray.getRGB());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return this.nameField.m_7933_(keyCode, scanCode, modifiers) || this.nameField.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean allowedToNameItem() {
        return ((ArtistTableMenu)this.f_97732_).isCanvasReady();
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }
}

