/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import me.dantaeusb.zetter.client.gui.painting.CanvasWidget;
import me.dantaeusb.zetter.client.gui.painting.ColorCodeWidget;
import me.dantaeusb.zetter.client.gui.painting.HelpWidget;
import me.dantaeusb.zetter.client.gui.painting.PaletteWidget;
import me.dantaeusb.zetter.client.gui.painting.SlidersWidget;
import me.dantaeusb.zetter.client.gui.painting.ToolsWidget;
import me.dantaeusb.zetter.menu.EaselContainerMenu;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class PaintingScreen
extends AbstractContainerScreen<EaselContainerMenu>
implements ContainerListener {
    private static final ResourceLocation PAINTING_RESOURCE = new ResourceLocation("zetter", "textures/gui/painting.png");
    protected final List<AbstractPaintingWidget> paintingWidgets = Lists.newArrayList();
    private ToolsWidget toolsWidget;
    private CanvasWidget canvasWidget;
    private PaletteWidget paletteWidget;
    private ColorCodeWidget colorCodeWidget;
    private SlidersWidget slidersWidget;
    private HelpWidget helpWidget;
    private final Player player;

    public PaintingScreen(EaselContainerMenu paintingContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)paintingContainer, playerInventory, title);
        this.player = playerInventory.f_35978_;
        this.f_97726_ = 176;
        this.f_97727_ = 185;
    }

    protected void m_7856_() {
        super.m_7856_();
        int CANVAS_POSITION_X = 48;
        int CANVAS_POSITION_Y = 9;
        int TOOLS_POSITION_X = 7;
        int TOOLS_POSITION_Y = 8;
        int PALETTE_POSITION_X = 147;
        int PALETTE_POSITION_Y = 13;
        int SLIDER_POSITION_X = 13;
        int SLIDER_OFFSET_Y = 117;
        int TEXTBOX_POSITION_X = 47;
        int TEXTBOX_POSITION_Y = 95;
        int HELP_POSITION_X = 165;
        boolean HELP_POSITION_Y = false;
        this.canvasWidget = new CanvasWidget(this, this.getGuiLeft() + 48, this.getGuiTop() + 9);
        this.paletteWidget = new PaletteWidget(this, this.getGuiLeft() + 147, this.getGuiTop() + 13);
        this.toolsWidget = new ToolsWidget(this, this.getGuiLeft() + 7, this.getGuiTop() + 8);
        this.slidersWidget = new SlidersWidget(this, this.getGuiLeft() + 13, this.getGuiTop() + 117);
        this.colorCodeWidget = new ColorCodeWidget(this, this.getGuiLeft() + 47, this.getGuiTop() + 95);
        this.helpWidget = new HelpWidget(this, this.getGuiLeft() + 165, this.getGuiTop() + 0);
        this.colorCodeWidget.initFields();
        this.addPaintingWidget(this.canvasWidget);
        this.addPaintingWidget(this.paletteWidget);
        this.addPaintingWidget(this.toolsWidget);
        this.addPaintingWidget(this.slidersWidget);
        this.addPaintingWidget(this.colorCodeWidget);
        this.addPaintingWidget(this.helpWidget);
        ((EaselContainerMenu)this.m_6262_()).setFirstLoadNotification(this::firstLoadUpdate);
        this.f_96541_.f_91068_.m_90926_(true);
        ((EaselContainerMenu)this.f_97732_).m_38893_(this);
    }

    public void addPaintingWidget(AbstractPaintingWidget widget) {
        this.paintingWidgets.add(widget);
        this.m_7787_(widget);
    }

    public <T extends GuiEventListener & NarratableEntry> void pipeWidget(T widget) {
        this.m_7787_(widget);
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public boolean isCanvasAvailable() {
        return ((EaselContainerMenu)this.f_97732_).isCanvasAvailable();
    }

    public boolean isPaletteAvailable() {
        return ((EaselContainerMenu)this.f_97732_).isPaletteAvailable();
    }

    public int getColorAt(int pixelIndex) {
        return ((EaselContainerMenu)this.f_97732_).getCanvasData().getColorAt(pixelIndex);
    }

    public int getColorAt(int pixelX, int pixelY) {
        return ((EaselContainerMenu)this.f_97732_).getCanvasData().getColorAt(pixelX, pixelY);
    }

    public int getCurrentColor() {
        return this.getPaletteColor(this.paletteWidget.getCurrentPaletteSlot());
    }

    public int getPaletteColor(int slot) {
        return ((EaselContainerMenu)this.f_97732_).getPaletteColor(slot);
    }

    public void firstLoadUpdate() {
        this.updateSlidersWithCurrentColor();
    }

    public void updateCurrentPaletteColor(int color) {
        ((EaselContainerMenu)this.f_97732_).setPaletteColor(this.paletteWidget.getCurrentPaletteSlot(), color);
        this.slidersWidget.updateSlidersWithCurrentColor();
    }

    public void pushPaletteUpdateColor() {
        ((EaselContainerMenu)this.f_97732_).sendPaletteUpdatePacket(this.paletteWidget.getCurrentPaletteSlot(), this.getCurrentColor());
    }

    public void updateSlidersWithCurrentColor() {
        this.slidersWidget.updateSlidersWithCurrentColor();
    }

    public void useTool(int canvasX, int canvasY) {
        switch (this.toolsWidget.getCurrentTool()) {
            case PENCIL: {
                ((EaselContainerMenu)this.m_6262_()).writePixelOnCanvasClientSide(canvasX, canvasY, this.getCurrentColor(), this.getPlayer().m_142081_());
                break;
            }
            case EYEDROPPER: {
                ((EaselContainerMenu)this.m_6262_()).eyedropper(this.paletteWidget.getCurrentPaletteSlot(), canvasX, canvasY);
                this.updateSlidersWithCurrentColor();
                break;
            }
            case BUCKET: {
                ((EaselContainerMenu)this.m_6262_()).bucket(canvasX, canvasY, this.getCurrentColor());
            }
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    public void m_181908_() {
        super.m_181908_();
        ((EaselContainerMenu)this.m_6262_()).tick();
        this.colorCodeWidget.tick();
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)PAINTING_RESOURCE);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.toolsWidget.render(matrixStack);
        this.canvasWidget.render(matrixStack);
        this.paletteWidget.render(matrixStack);
        this.slidersWidget.render(matrixStack);
        this.helpWidget.m_6305_(matrixStack, x, y, partialTicks);
        this.colorCodeWidget.m_6305_(matrixStack, x, y, partialTicks);
    }

    protected void m_7025_(PoseStack matrixStack, int x, int y) {
        super.m_7025_(matrixStack, x, y);
        for (AbstractPaintingWidget widget : this.paintingWidgets) {
            Component tooltip;
            if (!widget.m_5953_(x, y) || (tooltip = widget.getTooltip(x, y)) == null) continue;
            this.m_96602_(matrixStack, tooltip, x, y);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.canvasWidget.m_7979_(mouseX, mouseY, button, dragX, dragY);
        this.slidersWidget.m_7979_(mouseX, mouseY, button, dragX, dragY);
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.canvasWidget.m_6348_(mouseX, mouseY, button);
        this.slidersWidget.m_6348_(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void m_142153_(AbstractContainerMenu p_150524_, int p_150525_, int p_150526_) {
    }

    public void m_7934_(AbstractContainerMenu containerToSend, int slotInd, ItemStack stack) {
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }
}

