/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.painting;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.PaintingScreen;
import me.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import me.dantaeusb.zetter.core.Helper;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class CanvasWidget
extends AbstractPaintingWidget
implements Widget {
    private static final int CANVAS_SCALE_FACTOR = 5;
    private static final int size = Helper.getResolution().getNumeric() * 5;
    private boolean canvasDragging = false;

    public CanvasWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, size, size, (Component)new TranslatableComponent("container.zetter.painting.canvas"));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (this.m_5953_(mouseX, mouseY)) {
            this.canvasDragging = true;
            this.handleCanvasInteraction(iMouseX, iMouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.canvasDragging && this.m_5953_(mouseX, mouseY)) {
            int iMouseX = (int)mouseX;
            int iMouseY = (int)mouseY;
            this.handleCanvasInteraction(iMouseX, iMouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.canvasDragging = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected boolean handleCanvasInteraction(int iMouseX, int iMouseY) {
        int canvasX = (iMouseX - this.f_93620_) / 5;
        int canvasY = (iMouseY - this.f_93621_) / 5;
        this.parentScreen.useTool(canvasX, canvasY);
        return true;
    }

    public void render(PoseStack matrixStack) {
        if (!this.parentScreen.isCanvasAvailable()) {
            return;
        }
        for (int i = 0; i < Helper.getResolution().getNumeric() * Helper.getResolution().getNumeric(); ++i) {
            int localX = i % 16;
            int localY = i / 16;
            int color = this.parentScreen.getColorAt(i);
            int globalX = this.f_93620_ + localX * 5;
            int globalY = this.f_93621_ + localY * 5;
            this.m_93179_(matrixStack, globalX, globalY, globalX + 5, globalY + 5, color, color);
        }
    }
}

