/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.painting;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.PaintingScreen;
import me.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class PaletteWidget
extends AbstractPaintingWidget
implements Widget {
    static final int PALETTE_SCALE_FACTOR = 10;
    static final int PALETTE_OFFSET = 11;
    static final int PALETTE_COLS = 2;
    static final int WIDTH = 21;
    static final int HEIGHT = 87;
    private int currentPaletteSlot = 0;

    public PaletteWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 21, 87, (Component)new TranslatableComponent("container.zetter.painting.palette"));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public int getCurrentPaletteSlot() {
        return this.currentPaletteSlot;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        int slotIndex = -1;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        for (int i = 0; i < 14; ++i) {
            int slotX = this.f_93620_ + i % 2 * 11;
            int slotY = this.f_93621_ + i / 2 * 11;
            if (!PaintingScreen.isInRect(slotX, slotY, 10, 10, iMouseX, iMouseY) || !this.m_7972_(button)) continue;
            slotIndex = i;
            break;
        }
        if (slotIndex == -1) {
            return false;
        }
        this.setCurrentPaletteSlot(slotIndex);
        return true;
    }

    public void render(PoseStack matrixStack) {
        this.drawPalette(matrixStack);
        this.drawPaletteSelector(matrixStack);
    }

    protected void drawPalette(PoseStack matrixStack) {
        if (!this.parentScreen.isPaletteAvailable()) {
            return;
        }
        for (int i = 0; i < 14; ++i) {
            int fromX = this.f_93620_ + i % 2 * 11;
            int fromY = this.f_93621_ + i / 2 * 11;
            int color = this.parentScreen.getPaletteColor(i);
            this.m_93179_(matrixStack, fromX, fromY, fromX + 10, fromY + 10, color, color);
        }
    }

    protected void drawPaletteSelector(PoseStack matrixStack) {
        if (!this.parentScreen.isPaletteAvailable()) {
            return;
        }
        int SELECTOR_POSITION_U = 82;
        int SELECTOR_POSITION_V = 185;
        int PALETTE_BORDER = 3;
        int selectorPositionX = this.f_93620_ + (this.currentPaletteSlot % 2 != 0 ? 11 : 0) - 3;
        int selectorPositionY = this.f_93621_ + this.currentPaletteSlot / 2 * 11 - 3;
        this.m_93228_(matrixStack, selectorPositionX, selectorPositionY, 82, 185, 16, 16);
    }

    protected void setCurrentPaletteSlot(int slotIndex) {
        this.currentPaletteSlot = slotIndex;
        this.parentScreen.updateSlidersWithCurrentColor();
    }
}

