/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.painting;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.client.gui.PaintingScreen;
import me.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public class SlidersWidget
extends AbstractPaintingWidget
implements Widget {
    static final int SLIDER_WIDTH = 150;
    static final int SLIDER_HEIGHT = 9;
    static final int SLIDER_DISTANCE = 5;
    static final int WIDTH = 150;
    static final int HEIGHT = 37;
    private float sliderHuePercent = 0.0f;
    private float sliderSaturationPercent = 0.0f;
    private float sliderValuePercent = 0.0f;
    private Integer sliderDraggingIndex;

    public SlidersWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 150, 37, (Component)new TranslatableComponent("container.zetter.painting.sliders"));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (this.m_5953_(mouseX, mouseY)) {
            this.handleSliderInteraction(iMouseX, iMouseY);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.sliderDraggingIndex != null) {
            int iMouseX = (int)mouseX;
            int iMouseY = (int)mouseY;
            this.handleSliderInteraction(iMouseX, iMouseY, this.sliderDraggingIndex);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.sliderDraggingIndex != null) {
            this.parentScreen.pushPaletteUpdateColor();
        }
        this.sliderDraggingIndex = null;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void render(PoseStack matrixStack) {
        this.drawSliderBackground(matrixStack, 0, this.isDraggingSlider(0));
        this.drawSliderBackground(matrixStack, 1, this.isDraggingSlider(1));
        this.drawSliderBackground(matrixStack, 2, this.isDraggingSlider(2));
        this.drawSliderForeground(matrixStack, 0, SlidersWidget::getHue, this.isDraggingSlider(0));
        this.drawSliderForeground(matrixStack, 1, SlidersWidget::getSaturation, this.isDraggingSlider(1));
        this.drawSliderForeground(matrixStack, 2, SlidersWidget::getValue, this.isDraggingSlider(2));
        this.drawHandler(matrixStack, 0, this.sliderHuePercent, this.isDraggingSlider(0));
        this.drawHandler(matrixStack, 1, this.sliderSaturationPercent, this.isDraggingSlider(1));
        this.drawHandler(matrixStack, 2, this.sliderValuePercent, this.isDraggingSlider(2));
    }

    protected void drawSliderBackground(PoseStack matrixStack, int verticalOffset, boolean active) {
        int SLIDER_POSITION_U = 5;
        int SLIDER_POSITION_V = 217;
        int top = this.f_93621_ + verticalOffset * 14;
        int sliderV = 217;
        if (active) {
            sliderV += 9;
        }
        this.m_93228_(matrixStack, this.f_93620_, top, 5, sliderV, 150, 9);
    }

    protected void drawSliderForeground(PoseStack matrixStack, int verticalOffset, BiFunction<float[], Float, Integer> getColorLambda, boolean active) {
        int sliderContentGlobalLeft = this.f_93620_ + 3;
        int sliderContentGlobalTop = this.f_93621_ + verticalOffset * 14 + 3;
        int sliderContentWidth = 144;
        int sliderContentHeight = 3;
        if (active) {
            sliderContentGlobalTop -= 2;
            sliderContentHeight += 4;
        }
        Color currentColor = new Color(this.parentScreen.getCurrentColor());
        float[] currentColorHSB = Color.RGBtoHSB(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), null);
        for (int i = 0; i < sliderContentWidth; ++i) {
            int color = getColorLambda.apply(currentColorHSB, Float.valueOf((float)i / (float)sliderContentWidth));
            this.m_93179_(matrixStack, sliderContentGlobalLeft + i, sliderContentGlobalTop, sliderContentGlobalLeft + i + 1, sliderContentGlobalTop + sliderContentHeight, color, color);
        }
    }

    protected static Integer getHue(float[] inColorHSB, float percent) {
        return Color.HSBtoRGB(percent, 1.0f, 1.0f);
    }

    protected static Integer getSaturation(float[] inColorHSB, float percent) {
        return Color.HSBtoRGB(inColorHSB[0], 1.0f - percent, inColorHSB[2]);
    }

    protected static Integer getValue(float[] inColorHSB, float percent) {
        return Color.HSBtoRGB(inColorHSB[0], inColorHSB[1], 1.0f - percent);
    }

    public void updateSlidersWithCurrentColor() {
        Color currentColor = new Color(this.parentScreen.getCurrentColor());
        float[] currentColorHSB = Color.RGBtoHSB(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), null);
        this.sliderHuePercent = currentColorHSB[0];
        this.sliderSaturationPercent = 1.0f - currentColorHSB[1];
        this.sliderValuePercent = 1.0f - currentColorHSB[2];
    }

    protected void handleSliderInteraction(int mouseX, int mouseY) {
        this.handleSliderInteraction(mouseX, mouseY, null);
    }

    protected boolean isDraggingSlider(int index) {
        return this.sliderDraggingIndex != null && this.sliderDraggingIndex == index;
    }

    protected void handleSliderInteraction(int mouseX, int mouseY, @Nullable Integer sliderIndex) {
        if (sliderIndex == null) {
            for (int i = 0; i < 3; ++i) {
                int top = this.f_93621_ + i * 14;
                if (!PaintingScreen.isInRect(this.f_93620_, top, 150, 9, mouseX, mouseY)) continue;
                sliderIndex = i;
                break;
            }
            if (sliderIndex == null) {
                Zetter.LOG.warn("Cannot find slider!");
                return;
            }
        }
        this.sliderDraggingIndex = sliderIndex;
        float percent = (float)(mouseX - this.f_93620_ - 3) / 144.0f;
        float percentC = Mth.m_14036_((float)percent, (float)0.0f, (float)1.0f);
        this.updateSliderPosition(sliderIndex, percentC);
    }

    protected void updateSliderPosition(int sliderIndex, float percent) {
        int newColor;
        Color currentColor = new Color(this.parentScreen.getCurrentColor());
        float[] currentColorHSB = Color.RGBtoHSB(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), null);
        switch (sliderIndex) {
            case 0: {
                newColor = Color.HSBtoRGB(percent, currentColorHSB[1], currentColorHSB[2]);
                this.sliderHuePercent = percent;
                break;
            }
            case 1: {
                newColor = Color.HSBtoRGB(this.sliderHuePercent, 1.0f - percent, currentColorHSB[2]);
                this.sliderSaturationPercent = percent;
                break;
            }
            case 2: {
                newColor = Color.HSBtoRGB(this.sliderHuePercent, currentColorHSB[1], 1.0f - percent);
                this.sliderValuePercent = percent;
                break;
            }
            default: {
                newColor = this.parentScreen.getCurrentColor();
            }
        }
        this.parentScreen.updateCurrentPaletteColor(newColor);
    }

    protected void drawHandler(PoseStack matrixStack, int verticalOffset, float percent, boolean active) {
        boolean HANDLER_POSITION_U = false;
        int HANDLER_POSITION_V = 216;
        int HANDLER_WIDTH = 5;
        int HANDLER_HEIGHT = 11;
        int sliderContentWidth = 144;
        int sliderGlobalLeft = this.f_93620_ + (int)((float)sliderContentWidth * percent) + 3 - 2;
        int sliderGlobalTop = this.f_93621_ + verticalOffset * 14 - 1;
        int sliderV = 216;
        if (active) {
            sliderV += 11;
        }
        this.m_93228_(matrixStack, sliderGlobalLeft, sliderGlobalTop, 0, sliderV, 5, 11);
    }
}

