/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.painting;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.PaintingScreen;
import me.dantaeusb.zetter.client.gui.painting.AbstractPaintingWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;

public class ToolsWidget
extends AbstractPaintingWidget
implements Widget {
    private Tool currentTool = Tool.PENCIL;
    static final int TOOLS_SIZE = 16;
    static final int TOOLS_OFFSET = 17;

    public ToolsWidget(PaintingScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 16, 50, (Component)new TranslatableComponent("container.zetter.painting.tools"));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        int i = 0;
        for (Tool tool : Tool.values()) {
            int fromY = this.f_93621_ + i * 17;
            if (PaintingScreen.isInRect(this.f_93620_, fromY, 16, 16, mouseX, mouseY)) {
                return tool.title;
            }
            ++i;
        }
        return null;
    }

    public Tool getCurrentTool() {
        return this.currentTool;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        int i = 0;
        for (Tool tool : Tool.values()) {
            int fromY = this.f_93621_ + i * 17;
            if (PaintingScreen.isInRect(this.f_93620_, fromY, 16, 16, iMouseX, iMouseY) && this.m_7972_(button)) {
                this.setCurrentTool(tool);
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            ++i;
        }
        return false;
    }

    public void render(PoseStack matrixStack) {
        int i = 0;
        for (Tool tool : Tool.values()) {
            int fromY = this.f_93621_ + i * 17;
            int vOffset = tool.vPosition + (this.currentTool == tool ? 16 : 0);
            this.m_93228_(matrixStack, this.f_93620_, fromY, tool.uPosition, vOffset, 16, 16);
            ++i;
        }
    }

    protected void setCurrentTool(Tool tool) {
        this.currentTool = tool;
        this.parentScreen.updateSlidersWithCurrentColor();
    }

    public static enum Tool implements StringRepresentable
    {
        PENCIL("Pencil", new TranslatableComponent("container.zetter.painting.tools.pencil"), 176, 0),
        EYEDROPPER("Eyedropper", new TranslatableComponent("container.zetter.painting.tools.eyedropper"), 192, 0),
        BUCKET("Bucket", new TranslatableComponent("container.zetter.painting.tools.bucket"), 208, 0);

        private final String name;
        private final TranslatableComponent title;
        public final int uPosition;
        public final int vPosition;

        private Tool(String name, TranslatableComponent title, int uPosition, int vPosition) {
            this.name = name;
            this.title = title;
            this.uPosition = uPosition;
            this.vPosition = vPosition;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

