/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.canvastracker.ICanvasTracker;
import me.dantaeusb.zetter.client.model.EaselModel;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EaselRenderer
extends EntityRenderer<EaselEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("zetter:textures/entity/easel.png");
    protected EaselModel model;
    protected final List<RenderLayer<EaselEntity, EntityModel<EaselEntity>>> layers = Lists.newArrayList();
    protected int canvasRequestTimeout = 0;

    public EaselRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new EaselModel(context.m_174023_(EaselModel.EASEL_BODY_LAYER));
    }

    public final boolean addLayer(RenderLayer<EaselEntity, EntityModel<EaselEntity>> layer) {
        return this.layers.add(layer);
    }

    public void render(EaselEntity easelEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Minecraft minecraft = Minecraft.m_91087_();
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        boolean visible = !easelEntity.m_20145_() && !easelEntity.m_20177_((Player)minecraft.f_91074_);
        this.model.m_7695_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, visible ? 0.01f : 1.0f);
        if (easelEntity.hasCanvas()) {
            CanvasData canvasData = EaselRenderer.getCanvasData(easelEntity.f_19853_, easelEntity.getCanvasCode());
            if (canvasData != null) {
                float scaleFactor = 0.0625f;
                poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
                poseStack.m_85837_(-8.0, 12.5, -3.0);
                poseStack.m_85845_(Vector3f.f_122223_.m_122270_(0.1745f));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                poseStack.m_85837_(-16.0, -16.0, 0.1);
                CanvasRenderer.getInstance().renderCanvas(poseStack, buffer, easelEntity.getCanvasCode(), canvasData, packedLight);
            } else {
                CanvasRenderer.getInstance().queueCanvasTextureUpdate(AbstractCanvasData.Type.CANVAS, easelEntity.getCanvasCode());
            }
        }
        poseStack.m_85849_();
    }

    @Nullable
    public static CanvasData getCanvasData(Level world, String canvasName) {
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(world);
        if (canvasTracker == null) {
            return null;
        }
        return canvasTracker.getCanvasData(canvasName, CanvasData.class);
    }

    public ResourceLocation getTextureLocation(EaselEntity entity) {
        return TEXTURE;
    }
}

