/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterBlocks;
import me.dantaeusb.zetter.entity.item.CustomPaintingEntity;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.item.EaselItem;
import me.dantaeusb.zetter.item.FrameItem;
import me.dantaeusb.zetter.item.PaintingItem;
import me.dantaeusb.zetter.item.PaintsItem;
import me.dantaeusb.zetter.item.PaletteItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="zetter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ZetterItems {
    private static final List<Item> ITEMS = new ArrayList<Item>();
    public static final EaselItem EASEL = (EaselItem)ZetterItems.register("easel", new EaselItem());
    public static final BlockItem ARTIST = ZetterItems.registerBlockItem("artist_table", ZetterBlocks.ARTIST_TABLE);
    public static final CanvasItem CANVAS = (CanvasItem)ZetterItems.register("canvas", new CanvasItem());
    public static final PaintingItem PAINTING = (PaintingItem)ZetterItems.register("painting", new PaintingItem());
    public static final PaintsItem PAINTS = (PaintsItem)ZetterItems.register("paints", new PaintsItem());
    public static final PaletteItem PALETTE = (PaletteItem)ZetterItems.register("palette", new PaletteItem());
    public static final HashMap<String, Item> FRAMES = new HashMap();
    public static final FrameItem ACACIA_FRAME = ZetterItems.registerFrame("acacia_basic_frame", new FrameItem(CustomPaintingEntity.Materials.ACACIA, false));
    public static final FrameItem BIRCH_FRAME = ZetterItems.registerFrame("birch_basic_frame", new FrameItem(CustomPaintingEntity.Materials.BIRCH, false));
    public static final FrameItem DARK_OAK_FRAME = ZetterItems.registerFrame("dark_oak_basic_frame", new FrameItem(CustomPaintingEntity.Materials.DARK_OAK, false));
    public static final FrameItem JUNGLE_FRAME = ZetterItems.registerFrame("jungle_basic_frame", new FrameItem(CustomPaintingEntity.Materials.JUNGLE, false));
    public static final FrameItem OAK_FRAME = ZetterItems.registerFrame("oak_basic_frame", new FrameItem(CustomPaintingEntity.Materials.OAK, false));
    public static final FrameItem SPRUCE_FRAME = ZetterItems.registerFrame("spruce_basic_frame", new FrameItem(CustomPaintingEntity.Materials.SPRUCE, false));
    public static final FrameItem CRIMSON_FRAME = ZetterItems.registerFrame("crimson_basic_frame", new FrameItem(CustomPaintingEntity.Materials.CRIMSON, false));
    public static final FrameItem WARPED_FRAME = ZetterItems.registerFrame("warped_basic_frame", new FrameItem(CustomPaintingEntity.Materials.WARPED, false));
    public static final FrameItem ACACIA_PLATED_FRAME = ZetterItems.registerFrame("acacia_plated_frame", new FrameItem(CustomPaintingEntity.Materials.ACACIA, true));
    public static final FrameItem BIRCH_PLATED_FRAME = ZetterItems.registerFrame("birch_plated_frame", new FrameItem(CustomPaintingEntity.Materials.BIRCH, true));
    public static final FrameItem DARK_OAK_PLATED_FRAME = ZetterItems.registerFrame("dark_oak_plated_frame", new FrameItem(CustomPaintingEntity.Materials.DARK_OAK, true));
    public static final FrameItem JUNGLE_PLATED_FRAME = ZetterItems.registerFrame("jungle_plated_frame", new FrameItem(CustomPaintingEntity.Materials.JUNGLE, true));
    public static final FrameItem OAK_PLATED_FRAME = ZetterItems.registerFrame("oak_plated_frame", new FrameItem(CustomPaintingEntity.Materials.OAK, true));
    public static final FrameItem SPRUCE_PLATED_FRAME = ZetterItems.registerFrame("spruce_plated_frame", new FrameItem(CustomPaintingEntity.Materials.SPRUCE, true));
    public static final FrameItem CRIMSON_PLATED_FRAME = ZetterItems.registerFrame("crimson_plated_frame", new FrameItem(CustomPaintingEntity.Materials.CRIMSON, true));
    public static final FrameItem WARPED_PLATED_FRAME = ZetterItems.registerFrame("warped_plated_frame", new FrameItem(CustomPaintingEntity.Materials.WARPED, true));
    public static final FrameItem IRON_FRAME = ZetterItems.registerFrame("iron_frame", new FrameItem(CustomPaintingEntity.Materials.IRON, false));
    public static final FrameItem GOLD_FRAME = ZetterItems.registerFrame("gold_basic_frame", new FrameItem(CustomPaintingEntity.Materials.GOLD, false));
    public static final FrameItem GOLD_PLATE_FRAME = ZetterItems.registerFrame("gold_plated_frame", new FrameItem(CustomPaintingEntity.Materials.GOLD, true));

    private static BlockItem registerBlockItem(String name, Block block) {
        Item.Properties itemProps = new Item.Properties().m_41491_(CreativeModeTab.f_40756_);
        BlockItem blockItem = new BlockItem(block, itemProps);
        return (BlockItem)ZetterItems.register(name, (Item)blockItem);
    }

    private static FrameItem registerFrame(String name, FrameItem item) {
        item.setRegistryName("zetter", name);
        ITEMS.add(item);
        FRAMES.put(Helper.getFrameKey(item.getMaterial(), item.hasPlate()), item);
        return item;
    }

    private static Item register(String name, Item item) {
        item.setRegistryName("zetter", name);
        ITEMS.add(item);
        return item;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ITEMS.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
        ITEMS.clear();
    }
}

