/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.entity.item.container;

import com.google.common.collect.Lists;
import java.util.List;
import me.dantaeusb.zetter.core.ItemStackHandlerListener;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class EaselContainer
extends ItemStackHandler {
    public static final int STORAGE_SIZE = 2;
    public static final int CANVAS_SLOT = 0;
    public static final int PALETTE_SLOT = 1;
    private EaselEntity boundEasel;
    private List<ItemStackHandlerListener> listeners;

    public EaselContainer(EaselEntity easelEntity) {
        super(2);
        this.boundEasel = easelEntity;
    }

    public EaselContainer() {
        super(2);
    }

    public void addListener(ItemStackHandlerListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ItemStackHandlerListener listener) {
        this.listeners.remove(listener);
    }

    public boolean stillValid(Player player) {
        if (this.boundEasel != null) {
            return player.m_20275_((double)this.boundEasel.getPos().m_123341_() + 0.5, (double)this.boundEasel.getPos().m_123342_() + 0.5, (double)this.boundEasel.getPos().m_123343_() + 0.5) <= 64.0;
        }
        return true;
    }

    public boolean isItemValid(int index, ItemStack stack) {
        return index == 0 && stack.m_41720_() == ZetterItems.CANVAS || index == 1 && stack.m_41720_() == ZetterItems.PALETTE;
    }

    public ItemStack getCanvasStack() {
        return this.getStackInSlot(0);
    }

    public ItemStack getPaletteStack() {
        return this.getStackInSlot(1);
    }

    public ItemStack extractCanvasStack() {
        return this.extractItem(0, this.getSlotLimit(0), false);
    }

    public ItemStack extractPaletteStack() {
        return this.extractItem(1, this.getSlotLimit(1), false);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public void setCanvasStack(ItemStack canvasStack) {
        this.setStackInSlot(0, canvasStack);
    }

    public void setPaletteStack(ItemStack canvasStack) {
        this.setStackInSlot(1, canvasStack);
    }

    public void changed() {
        this.onContentsChanged(0);
    }

    protected void onContentsChanged(int slot) {
        if (this.listeners != null) {
            for (ItemStackHandlerListener listener : this.listeners) {
                listener.containerChanged(this);
            }
        }
    }
}

