/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item;

import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.canvastracker.ICanvasTracker;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CanvasItem
extends Item {
    public static final String NBT_TAG_CANVAS_CODE = "CanvasCode";

    public CanvasItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_));
    }

    @Nullable
    public static CanvasData getCanvasData(ItemStack stack, @Nullable Level world) {
        Item canvas = stack.m_41720_();
        if (canvas instanceof CanvasItem) {
            return ((CanvasItem)canvas).getCustomCanvasData(stack, world);
        }
        return null;
    }

    @Nullable
    protected CanvasData getCustomCanvasData(ItemStack stack, Level world) {
        ICanvasTracker canvasTracker;
        CanvasData canvasData = null;
        String canvasCode = CanvasItem.getCanvasCode(stack);
        if (canvasCode == null && world instanceof ServerLevel) {
            canvasCode = CanvasItem.createNewCanvasData(world);
            CanvasItem.setCanvasCode(stack, canvasCode);
        }
        if ((canvasTracker = Helper.getWorldCanvasTracker(world)) != null) {
            canvasData = canvasTracker.getCanvasData(canvasCode, CanvasData.class);
        } else {
            Zetter.LOG.error("Unable to find CanvasTracker capability");
        }
        if (canvasData == null && world instanceof ServerLevel) {
            Zetter.LOG.error("Unable to find canvas data after creation");
        }
        return canvasData;
    }

    @Nullable
    public static String getCanvasCode(@Nullable ItemStack stack) {
        if (stack == null || !stack.m_150930_((Item)ZetterItems.CANVAS)) {
            return null;
        }
        CompoundTag compoundNBT = stack.m_41783_();
        String canvasCode = null;
        if (compoundNBT != null && compoundNBT.m_128441_(NBT_TAG_CANVAS_CODE)) {
            canvasCode = compoundNBT.m_128461_(NBT_TAG_CANVAS_CODE);
        }
        return canvasCode;
    }

    public static void setCanvasCode(ItemStack stack, String canvasCode) {
        stack.m_41784_().m_128359_(NBT_TAG_CANVAS_CODE, canvasCode);
    }

    private static void createAndStoreCanvasData(ItemStack stack, Level world) {
        String canvasCode = CanvasItem.createNewCanvasData(world);
        CanvasItem.setCanvasCode(stack, canvasCode);
    }

    private static String createNewCanvasData(Level world) {
        ICanvasTracker canvasTracker = Helper.getWorldCanvasTracker(world);
        int numericResolution = Helper.getResolution().getNumeric();
        CanvasData canvasData = CanvasData.createFresh(Helper.getResolution(), numericResolution, numericResolution);
        String canvasCode = CanvasData.getCanvasCode(canvasTracker.getNextCanvasId());
        canvasTracker.registerCanvasData(canvasCode, canvasData);
        return canvasCode;
    }
}

