/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item;

import java.util.Optional;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.entity.item.CustomPaintingEntity;
import me.dantaeusb.zetter.item.PaintingItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class FrameItem
extends PaintingItem {
    private CustomPaintingEntity.Materials material;
    private boolean hasPlate;

    public FrameItem(CustomPaintingEntity.Materials material, boolean plated) {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_));
        this.material = material;
        this.hasPlate = plated;
    }

    public CustomPaintingEntity.Materials getMaterial() {
        return this.material;
    }

    public boolean hasPlate() {
        return this.hasPlate;
    }

    public static byte getHasPaintingPropertyOverride(ItemStack stack, @Nullable Level world, @Nullable LivingEntity livingEntity, int weirdInt) {
        EnumFrameStyle hasPainting = StringUtil.m_14408_((String)FrameItem.getPaintingCode(stack)) ? EnumFrameStyle.EMPTY : EnumFrameStyle.PAINTING;
        return hasPainting.getPropertyOverrideValue();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos facePos = blockPos.m_142300_(direction);
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player != null && !this.canPlace(player, direction, stack, facePos)) {
            return InteractionResult.FAIL;
        }
        if (StringUtil.m_14408_((String)FrameItem.getPaintingCode(stack))) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        CustomPaintingEntity paintingEntity = new CustomPaintingEntity(world, facePos, direction, this.material, this.hasPlate, FrameItem.getPaintingCode(stack), FrameItem.getBlockSize(stack), FrameItem.getGeneration(stack));
        if (!paintingEntity.m_7088_()) {
            return InteractionResult.CONSUME;
        }
        if (!world.f_46443_) {
            paintingEntity.m_7084_();
            world.m_7967_((Entity)paintingEntity);
        }
        player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected boolean canPlace(Player playerIn, Direction directionIn, ItemStack itemStackIn, BlockPos posIn) {
        return !directionIn.m_122434_().m_122478_() && playerIn.m_36204_(posIn, directionIn, itemStackIn);
    }

    public static enum EnumFrameStyle implements StringRepresentable
    {
        EMPTY(0, "empty", "Missing painting"),
        PAINTING(1, "painting", "Framed painting");

        private final byte nbtId;
        private final String name;
        private final String description;

        private EnumFrameStyle(int nbtId, String name, String description) {
            this.nbtId = (byte)nbtId;
            this.name = name;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public byte getPropertyOverrideValue() {
            return this.nbtId;
        }

        public static EnumFrameStyle fromNBT(CompoundTag compoundNBT, String tagname) {
            byte hasPaintingValue = 0;
            if (compoundNBT != null && compoundNBT.m_128441_(tagname)) {
                hasPaintingValue = compoundNBT.m_128445_(tagname);
            }
            Optional<EnumFrameStyle> hasPainting = EnumFrameStyle.getEnumFromValue(hasPaintingValue);
            return hasPainting.orElse(EMPTY);
        }

        public void putIntoNBT(CompoundTag compoundNBT, String tagName) {
            compoundNBT.m_128344_(tagName, this.nbtId);
        }

        private static Optional<EnumFrameStyle> getEnumFromValue(byte ID) {
            for (EnumFrameStyle fullness : EnumFrameStyle.values()) {
                if (fullness.nbtId != ID) continue;
                return Optional.of(fullness);
            }
            return Optional.empty();
        }
    }
}

