/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item;

import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaintingItem
extends Item {
    public static final String NBT_TAG_CACHED_PAINTING_NAME = "CachedPaintingName";
    public static final String NBT_TAG_CACHED_AUTHOR_NAME = "CachedAuthorName";
    public static final String NBT_TAG_CACHED_STRING_SIZE = "CachedStringSize";
    public static final String NBT_TAG_CACHED_BLOCK_SIZE = "CachedBlockSize";
    public static final String NBT_TAG_GENERATION = "Generation";
    public static final int GENERATION_ORIGINAL = 0;
    public static final int GENERATION_COPY = 1;
    public static final int GENERATION_COPY_OF_COPY = 2;

    public PaintingItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_));
    }

    public PaintingItem(Item.Properties properties) {
        super(properties);
    }

    public static void setPaintingData(ItemStack stack, String paintingCode, PaintingData paintingData, int generation) {
        PaintingItem.setPaintingCode(stack, paintingCode);
        PaintingItem.setCachedAuthorName(stack, paintingData.getAuthorName());
        PaintingItem.setCachedPaintingName(stack, paintingData.getPaintingName());
        int widthBlocks = paintingData.getWidth() / paintingData.getResolution().getNumeric();
        int heightBlocks = paintingData.getHeight() / paintingData.getResolution().getNumeric();
        TranslatableComponent blockSizeString = new TranslatableComponent("item.zetter.painting.size", new Object[]{Integer.toString(widthBlocks), Integer.toString(heightBlocks)});
        PaintingItem.setBlockSize(stack, new int[]{widthBlocks, heightBlocks});
        PaintingItem.setCachedStringSize(stack, blockSizeString.getString());
        PaintingItem.setGeneration(stack, generation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            String authorName = PaintingItem.getCachedAuthorName(stack);
            if (StringUtil.m_14408_((String)authorName)) {
                authorName = new TranslatableComponent("item.zetter.painting.unknown").getString();
            }
            tooltip.add((Component)new TranslatableComponent("book.byAuthor", new Object[]{authorName}).m_130940_(ChatFormatting.GRAY));
            String stringSize = PaintingItem.getCachedStringSize(stack);
            if (!StringUtil.m_14408_((String)stringSize)) {
                tooltip.add((Component)new TextComponent(stringSize).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41782_()) {
            String paintingName = PaintingItem.getCachedPaintingName(stack);
            if (StringUtil.m_14408_((String)paintingName)) {
                if (StringUtil.m_14408_((String)PaintingItem.getPaintingCode(stack))) {
                    return super.m_7626_(stack);
                }
                paintingName = new TranslatableComponent("item.zetter.painting.unnamed").getString();
            }
            if (!StringUtil.m_14408_((String)paintingName)) {
                return new TextComponent(paintingName);
            }
        }
        return super.m_7626_(stack);
    }

    protected static void setPaintingCode(ItemStack stack, String canvasCode) {
        stack.m_41784_().m_128359_("PaintingCode", canvasCode);
    }

    @Nullable
    public static String getPaintingCode(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.m_128461_("PaintingCode");
    }

    public static void setCachedAuthorName(ItemStack stack, String authorName) {
        stack.m_41784_().m_128359_(NBT_TAG_CACHED_AUTHOR_NAME, authorName);
    }

    @Nullable
    public static String getCachedAuthorName(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.m_128461_(NBT_TAG_CACHED_AUTHOR_NAME);
    }

    public static void setCachedPaintingName(ItemStack stack, String paintingName) {
        stack.m_41784_().m_128359_(NBT_TAG_CACHED_PAINTING_NAME, paintingName);
    }

    @Nullable
    public static String getCachedPaintingName(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.m_128461_(NBT_TAG_CACHED_PAINTING_NAME);
    }

    protected static void setBlockSize(ItemStack stack, int[] blockSize) {
        stack.m_41784_().m_128385_(NBT_TAG_CACHED_BLOCK_SIZE, blockSize);
    }

    @Nullable
    public static int[] getBlockSize(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        if (compoundNBT.m_128441_("BlockSize")) {
            int[] oldBlockSize = compoundNBT.m_128465_("BlockSize");
            PaintingItem.setBlockSize(stack, oldBlockSize);
            compoundNBT.m_128473_("BlockSize");
        }
        return compoundNBT.m_128465_(NBT_TAG_CACHED_BLOCK_SIZE);
    }

    protected static void setCachedStringSize(ItemStack stack, String stringSize) {
        stack.m_41784_().m_128359_(NBT_TAG_CACHED_STRING_SIZE, stringSize);
    }

    @Nullable
    public static String getCachedStringSize(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return null;
        }
        return compoundNBT.m_128461_(NBT_TAG_CACHED_STRING_SIZE);
    }

    public static void setGeneration(ItemStack stack, int generation) {
        stack.m_41784_().m_128405_(NBT_TAG_GENERATION, generation);
    }

    public static int getGeneration(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return 0;
        }
        return compoundNBT.m_128451_(NBT_TAG_GENERATION);
    }
}

